/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.base.AvoidObjectComparisonWithSelfCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;

@Check(id="cqse-avoid-object-comparison-with-self", languages={ELanguage.JAVA, ELanguage.CS, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AvoidObjectComparisonWithSelfCheck
extends AvoidObjectComparisonWithSelfCheckBase {
    private static final String XCT_ASSERT_STATEMENT_PREFIX = "XCTAssert";

    protected List<Integer> getIndicesOfComparisonExpression(List<IToken> tokens) {
        String equals;
        List candidates;
        if (this.context.getLanguage().isObjectiveCOrObjectiveCpp()) {
            candidates = AvoidObjectComparisonWithSelfCheck.getCandidatesForObjectiveC(tokens);
            equals = "isEqual";
        } else {
            candidates = TokenStreamUtils.firstTokenOfTypeSequences(tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.DOT, ETokenType.IDENTIFIER, ETokenType.LPAREN, ETokenType.IDENTIFIER, ETokenType.RPAREN});
            equals = "equals";
        }
        return CollectionUtils.filter(candidates, index -> {
            if (!this.context.getLanguage().isObjectiveCOrObjectiveCpp()) {
                index = index + 1;
            }
            return ((IToken)tokens.get((int)index)).getText().equalsIgnoreCase(equals);
        });
    }

    private static List<Integer> getCandidatesForObjectiveC(List<IToken> tokens) {
        return TokenStreamUtils.firstTokenOfTypeSequences(tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.COLON, ETokenType.IDENTIFIER}).stream().filter(index -> index - 4 < 0 || !((IToken)tokens.get(index - 4)).getText().startsWith(XCT_ASSERT_STATEMENT_PREFIX)).collect(Collectors.toList());
    }

    protected int getSecondOperandIndex(int index) {
        if (this.context.getLanguage().isObjectiveCOrObjectiveCpp()) {
            return index + 2;
        }
        return index + 3;
    }
}

