/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-bad-assignments", languages={ELanguage.JAVA, ELanguage.XTEND, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class BadAssignmentsCheck
extends CheckImplementationBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String CHECK_NAME = "Bad assignments";
    private static final Set<String> SIMPLE_CONDITION_SUBTYPES = Set.of("while", "if", "else if", "elseif");
    @CheckOption(name="Bad assignments: Allow variable initialization in conditions", description="Whether variables initializations inside conditional statements should be allowed or not.")
    private boolean allowVariableInitializationsInConditions = false;
    @CheckOption(name="Bad assignments: Ignore given method names", description="Set of method names that will be ignored and will not cause a finding when used in an assignment inside a conditional statement (e.g., if, while, for).")
    private Set<String> ignoredMethodNames = Collections.emptySet();

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            int equalSignIndex;
            int secondSemicolon;
            int firstSemicolon;
            UnmodifiableList tokens;
            if (SIMPLE_CONDITION_SUBTYPES.contains(statement.getSubtype())) {
                tokens = statement.ownStartTokens();
                int equalSignIndex2 = TokenStreamUtils.firstTokenMatching((List)tokens, (ITokenMatcher)ETokenType.EQ);
                if (equalSignIndex2 == -1 || this.isFiltered(statement, (List<IToken>)tokens, equalSignIndex2) || this.isIgnoredMethodCall((List<IToken>)tokens, equalSignIndex2)) continue;
                this.buildFinding("Avoid assignments in `" + statement.getSubtype() + "` statements", this.buildLocation().forEntityFirstLine(statement)).createAndStore();
                continue;
            }
            if (!"for".equals(statement.getSubtype()) || (firstSemicolon = TokenStreamUtils.firstTokenMatching((List)(tokens = statement.ownStartTokens()), (ITokenMatcher)ETokenType.SEMICOLON)) == -1 || (secondSemicolon = TokenStreamUtils.firstTokenMatching((List)tokens, (int)(firstSemicolon + 1), (ITokenMatcher)ETokenType.SEMICOLON)) == -1 || (equalSignIndex = TokenStreamUtils.firstTokenMatching((List)tokens, (int)(firstSemicolon + 1), (int)secondSemicolon, (ITokenMatcher)ETokenType.EQ)) == -1 || this.isIgnoredMethodCall((List<IToken>)tokens, equalSignIndex)) continue;
            this.buildFinding("Avoid assignments in condition of `" + statement.getSubtype() + "` statements", this.buildLocation().forEntityFirstLine(statement)).createAndStore();
        }
    }

    private boolean isFiltered(ShallowEntity statement, List<IToken> tokens, int equalSignIndex) {
        return this.allowVariableInitializationsInConditions && BadAssignmentsCheck.isVariableDefinition(tokens, equalSignIndex) || this.isObjectiveCInitFunctionAssignment(statement, tokens, equalSignIndex);
    }

    private boolean isIgnoredMethodCall(List<IToken> tokens, int equalSignIndex) {
        if (this.ignoredMethodNames.isEmpty()) {
            return false;
        }
        for (int i = equalSignIndex + 1; i < tokens.size(); ++i) {
            IToken token = tokens.get(i);
            if (!this.ignoredMethodNames.contains(token.getText())) continue;
            if (this.context.getLanguage() == ELanguage.JAVA) {
                int followingTokenIndex = i + 1;
                if (followingTokenIndex >= tokens.size() || tokens.get(followingTokenIndex).getType() != ETokenType.LPAREN) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private static boolean isVariableDefinition(List<IToken> tokens, int equalSignIndex) {
        for (int indexOfPossibleTypeName = equalSignIndex - 2; indexOfPossibleTypeName >= 0; --indexOfPossibleTypeName) {
            ETokenType typeOfPossibleTypeNameToken = tokens.get(indexOfPossibleTypeName).getType();
            if (typeOfPossibleTypeNameToken == ETokenType.MULT || typeOfPossibleTypeNameToken == ETokenType.AND) continue;
            return typeOfPossibleTypeNameToken.isIdentifier() || typeOfPossibleTypeNameToken.isKeyword();
        }
        return false;
    }

    private boolean isObjectiveCInitFunctionAssignment(ShallowEntity statement, List<IToken> tokens, int equalSignIndex) {
        if (this.context.getLanguage().isObjectiveCOrObjectiveCpp() && statement.getSubtype().equals("if")) {
            if (equalSignIndex - 1 < 0 || equalSignIndex + 1 >= tokens.size() || equalSignIndex + 2 >= tokens.size()) {
                LOGGER.error("The {} file {} has an unknown 'if' construct in line {}. This indicates a parser problem.", (Object)this.context.getLanguage(), (Object)this.context.getUniformPath(), (Object)statement.getStartLine());
                return false;
            }
            IToken tokenBeforeEquals = tokens.get(equalSignIndex - 1);
            IToken firstTokenAfterEqual = tokens.get(equalSignIndex + 1);
            IToken secondTokenAfterEqual = tokens.get(equalSignIndex + 2);
            return tokenBeforeEquals.getType() == ETokenType.SELF && firstTokenAfterEqual.getType() == ETokenType.LBRACK && EnumSet.of(ETokenType.SELF, ETokenType.SUPER).contains(secondTokenAfterEqual.getType());
        }
        return false;
    }
}

