/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.cpp.misra.TokenFilterCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.regex.Pattern;

@Check(id="cqse-octal-constant", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.JAVA, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class OctalConstantCheck
extends TokenFilterCheckBase {
    private static final Pattern NON_ZERO_OCTAL_PATTERN = Pattern.compile("^0+[1-9]");

    @Override
    protected String getFindingMessage(IToken token) {
        String text = token.getText();
        return "Usage of octal constant `" + text + "` is not allowed, because it may be misinterpreted as `" + text.substring(1) + "`";
    }

    @Override
    protected boolean isValidToken(IToken token) {
        return token.getType() != ETokenType.INTEGER_LITERAL || !NON_ZERO_OCTAL_PATTERN.matcher(token.getText()).find();
    }
}

