/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cobol;

import eu.cqse.check.cobol.CobolAvoidDiscouragedStatementsCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import java.util.Arrays;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="cqse-cobol-program-exit", languages={ELanguage.COBOL}, parameters={})
public class CobolProgramExitCheck
extends CobolAvoidDiscouragedStatementsCheckBase {
    public CobolProgramExitCheck() {
        super(Arrays.asList({ETokenType.STOP, ETokenType.RUN}, {ETokenType.EXIT, ETokenType.PROGRAM}));
    }

    @Override
    protected void createDiscouragedStatementFinding(List<IToken> statementTokens) throws CheckException {
        this.buildFinding("Discouraged exit statement " + MarkupUtils.escapeMarkdownRelevantSymbols((String)TokenStreamTextUtils.concatTokenTexts(statementTokens, (String)" ")), this.buildLocation().betweenTokens(statementTokens.get(0), (IToken)CollectionUtils.getLast(statementTokens))).createAndStore();
    }
}

