/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-cpp-public-class-attribute", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class CppPublicClassAttributeCheck
extends CheckImplementationBase {
    public static final String CHECK_NAME = "Public class attribute (C++)";

    public void execute() throws CheckException {
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(ECodeViewOption.FILTERED_PREPROCESSED), (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            if (!"class".equals(type.getSubtype())) continue;
            this.processEntity(type);
        }
    }

    private void processEntity(ShallowEntity entity) {
        ETokenType currentVisibility = ETokenType.PRIVATE;
        for (ShallowEntity child : entity.getChildren()) {
            switch (child.getType()) {
                case META: {
                    currentVisibility = CppPublicClassAttributeCheck.updateVisibility(child, currentVisibility);
                    break;
                }
                case ATTRIBUTE: {
                    if (currentVisibility != ETokenType.PUBLIC || LanguageFeatureParser.CPP.isConstant(child)) break;
                    this.buildFinding("Attribute `" + child.getName() + "` should not be public", this.buildLocation().forEntityFirstLine(child)).createAndStore();
                    break;
                }
            }
        }
    }

    private static ETokenType updateVisibility(ShallowEntity metaEntity, ETokenType oldVisibility) {
        return switch (metaEntity.getSubtype()) {
            case "public" -> ETokenType.PUBLIC;
            case "protected" -> ETokenType.PROTECTED;
            case "private" -> ETokenType.PRIVATE;
            default -> oldVisibility;
        };
    }
}

