/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Iterator;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-declarations-in-namespace", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class DeclarationsInNamespaceCheck
extends CheckImplementationBase {
    private static final String MAIN_FUNCTION_NAME = "main";

    public void execute() throws CheckException {
        List topLevelEntities = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        for (ShallowEntity topLevelEntity : topLevelEntities) {
            if (topLevelEntity.getType() == EShallowEntityType.MODULE && "namespace".equals(topLevelEntity.getSubtype()) || topLevelEntity.getType() == EShallowEntityType.META || this.isSpecialIgnoredCase(topLevelEntity)) continue;
            this.buildFinding("`" + topLevelEntity.getName() + "` should be part of a namespace", this.buildLocation().forEntity(topLevelEntity)).createAndStore();
        }
    }

    protected boolean isSpecialIgnoredCase(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.METHOD && MAIN_FUNCTION_NAME.equals(entity.getName()) || DeclarationsInNamespaceCheck.isExternCDefinition(entity) || DeclarationsInNamespaceCheck.isExplicitOutsideNamespaceDeclaration(entity);
    }

    private static boolean isExternCDefinition(ShallowEntity entity) {
        ShallowEntity previousEntity = ShallowEntityTraversalUtils.getPreviousEntity((ShallowEntity)entity);
        if (previousEntity == null) {
            return false;
        }
        return previousEntity.getSubtype().equals("extern C prefix");
    }

    private static boolean isExplicitOutsideNamespaceDeclaration(ShallowEntity entity) {
        UnmodifiableList startTokens = entity.ownStartTokens();
        List sequenceStartingIndices = TokenStreamUtils.allStartingIndicesOfTypeSequence((List)startTokens, (int)0, (int)startTokens.size(), (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.SCOPE, ETokenType.IDENTIFIER});
        Iterator iterator = sequenceStartingIndices.iterator();
        while (iterator.hasNext()) {
            IToken identifierToken;
            int sequenceStartingIndex = (Integer)iterator.next();
            if (sequenceStartingIndex + 2 > startTokens.size() || !(identifierToken = (IToken)startTokens.get(sequenceStartingIndex + 2)).getText().equals(entity.getName())) continue;
            return true;
        }
        return false;
    }
}

