/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.misra;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-flexible-array-member", languages={ELanguage.C}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class FlexibleArrayMemberCheck
extends CheckImplementationBase {
    private static final TokenPattern FLEXIBLE_ARRAY_MEMBER_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER, ETokenType.LBRACK, ETokenType.RBRACK, ETokenType.SEMICOLON}).endOfStream();

    public void execute() throws CheckException {
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            ShallowEntity lastChild;
            if (!"struct".equals(type.getSubtype()) || (lastChild = (ShallowEntity)CollectionUtils.getLast((List)type.getChildren())) == null) continue;
            this.processEntity(lastChild);
        }
    }

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    private void processEntity(ShallowEntity entity) {
        UnmodifiableList entityTokens = entity.includedTokens();
        if (FLEXIBLE_ARRAY_MEMBER_PATTERN.matchesAnywhere((List)entityTokens)) {
            String arrayIdentifier = ((IToken)entityTokens.get(TokenStreamUtils.firstTokenMatching((List)entityTokens, (ITokenMatcher)ETokenType.LBRACK) - 1)).getText();
            this.buildFinding("Flexible array member `" + arrayIdentifier + "` shall not be used", this.buildLocation().forLine(entity.getStartLine())).createAndStore();
        }
    }
}

