/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.misra.switches;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-switch-clauses-are-in-switch-statement-body", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class SwitchClausesAreInSwitchStatementBodyCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List metaEntities = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.META);
        for (ShallowEntity metaEntity : metaEntities) {
            if (!"case".equals(metaEntity.getSubtype()) && !"default".equals(metaEntity.getSubtype())) continue;
            this.processEntity(metaEntity);
        }
    }

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    private void processEntity(ShallowEntity entity) {
        if (!entity.getParent().getSubtype().equals("switch")) {
            Object inferredInformation = entity.getSubtype();
            if (((String)inferredInformation).equals("case")) {
                inferredInformation = (String)inferredInformation + " " + entity.getName();
            }
            this.buildFinding("`" + (String)inferredInformation + "` is not directly enclosed by `switch`", this.buildLocation().forLine(entity.getStartLine())).createAndStore();
        }
    }
}

