/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.misra.switches;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.SwitchStatementUtils;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-switch-statement-demands-default-label-well-placed", languages={ELanguage.JAVA, ELanguage.CS, ELanguage.XTEND, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.JAVASCRIPT, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class SwitchStatementDemandsDefaultLabelWellPlacedCheck
extends CheckImplementationBase {
    @CheckOption(name="Allow `default` as first label of switch statement", description="Controls having `default` as first label of switch statement")
    private boolean allowDefaultAsFirstClauseOfSwitchStatement = false;

    public void execute() throws CheckException {
        List allEntities = ShallowEntityTraversalUtils.getAllEntities((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()));
        for (ShallowEntity entity : allEntities) {
            if (!"switch".equals(entity.getSubtype()) && !"switch expression".equals(entity.getSubtype())) continue;
            this.processEntity(entity);
        }
    }

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    private void processEntity(ShallowEntity entity) {
        List<ShallowEntity> labels = entity.getChildrenOfType(EShallowEntityType.META).stream().filter(SwitchStatementUtils::isCaseOrDefault).toList();
        if (labels.isEmpty()) {
            return;
        }
        int startIndex = 0;
        if (this.allowDefaultAsFirstClauseOfSwitchStatement) {
            startIndex = 1;
        }
        for (int i = startIndex; i < labels.size() - 1; ++i) {
            ShallowEntity label = labels.get(i);
            if (!SwitchStatementUtils.isDefault((ShallowEntity)label)) continue;
            this.buildFinding(this.getFindingMessage(), this.buildLocation().forLine(label.getStartLine())).createAndStore();
        }
    }

    private String getFindingMessage() {
        if (this.allowDefaultAsFirstClauseOfSwitchStatement) {
            return "`default` should be the first or last statement within `switch`";
        }
        return "`default` should be the last statement within `switch`";
    }
}

