/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cs;

import eu.cqse.check.clike.CatchUnwantedExceptionCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;

@Check(id="cqse-cs-catch-unwanted-exception", languages={ELanguage.CS}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class CsCatchUnwantedExceptionCheck
extends CatchUnwantedExceptionCheckBase {
    public static final String CHECK_OPTION_NAME = "Unwanted catch of exception (C#): Exception names";
    private static final UnmodifiableSet<String> SHOULD_NOT_BE_CAUGHT_EXCEPTION_NAMES = CollectionUtils.asUnmodifiable((Set)CollectionUtils.asHashSet((Object[])new String[]{"NullReferenceException", "StackOverflowException", "OutOfMemoryException", "ThreadAbortException", "ExecutionEngineException", "IndexOutOfRangeException", "AccessViolationException", "DivideByZeroException", "InvalidCastException", "ArithmeticException", "TypeInitializationException", "ArgumentException"}));
    @CheckOption(name="Unwanted catch of exception (C#): Exception names", description="List of exception names for which a finding is generated.")
    private Set<String> exceptionNames = new HashSet<String>((Collection<String>)SHOULD_NOT_BE_CAUGHT_EXCEPTION_NAMES);

    protected boolean createFindingForException(Optional<String> className, ShallowEntity entity) {
        return className.filter(this.exceptionNames::contains).isPresent();
    }
}

