/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cs;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-httpclient-in-using-statements", languages={ELanguage.CS}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class HttpClientInUsingStatementCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "`HttpClient` should not be instantiated with `using`";
    private static final TokenPattern CLIENT_NAMESPACE = new TokenPattern().sequence(new Object[]{TokenPattern.text((String)"System"), ETokenType.DOT, TokenPattern.text((String)"Net"), ETokenType.DOT, TokenPattern.text((String)"Http"), ETokenType.DOT});
    private static final TokenPattern NEW_HTTPCLIENT_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.NEW}).optional(new Object[]{CLIENT_NAMESPACE}).regex("\\bHttpClient\\b");

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!"simple statement".equals(statement.getSubtype()) && !"using".equals(statement.getSubtype())) continue;
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) {
        UnmodifiableList tokens = entity.ownStartTokens();
        if (((IToken)tokens.get(0)).getType().equals((Object)ETokenType.USING) && NEW_HTTPCLIENT_PATTERN.matchesAnywhere((List)tokens)) {
            this.buildFinding(FINDING_MESSAGE, this.buildLocation().forEntityFirstLine(entity)).createAndStore();
        }
    }
}

