/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cs;

import com.google.common.collect.Sets;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.shallowparser.languages.cs.CsShallowParser;
import eu.cqse.check.framework.util.tokens.MatchGroupElement;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.conqat.lib.commons.assertion.CCSMAssert;

public abstract class NoParameterModifierBase
extends CheckImplementationBase {
    private static final int METHOD_NAME_GROUP_INDEX = 1;
    private static final TokenPattern METHOD_DECLARATION_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER}).group(1).skipTo(new Object[]{ETokenType.LPAREN});
    private static final Set<String> ANONYMOUS_FUNCTION_SUBTYPE_NAMES = Sets.newHashSet((Object[])new String[]{"anonymous method", "anonymous function", "lambda"});
    private final ETokenType modifier;
    private static final int PARAMETER_GROUP_INDEX = 0;
    private TokenPattern modifiedParametersPattern;
    private final int identifierInMatchIndex = 0;
    protected ELanguage language;

    protected NoParameterModifierBase(ETokenType modifier) {
        this.modifier = modifier;
    }

    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        if (methods.isEmpty()) {
            return;
        }
        this.setModifiedParametersPatterBasedOnLanguage(methods);
        for (ShallowEntity method : methods) {
            if (!TokenStreamUtils.contains((List)method.ownStartTokens(), (ETokenType)this.modifier)) continue;
            this.processEntity(method);
        }
    }

    protected void setModifiedParametersPatterBasedOnLanguage(List<ShallowEntity> entities) {
        this.language = TokenStreamUtils.getLanguage((Collection)entities.getFirst().getAllTokensOfFile());
        if (this.language == null) {
            return;
        }
        switch (this.language) {
            case PLSQL: {
                this.modifiedParametersPattern = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER, this.modifier}).group(0);
                break;
            }
            case ESQL: {
                this.modifiedParametersPattern = new TokenPattern().sequence(new Object[]{this.modifier}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0);
                break;
            }
            case CS: {
                this.modifiedParametersPattern = new TokenPattern().sequence(new Object[]{this.modifier}).alternative(new Object[]{new TokenPattern().sequence(new Object[]{CsShallowParser.VALID_IDENTIFIERS}).repeated(new Object[]{ETokenType.DOT, CsShallowParser.VALID_IDENTIFIERS}), new TokenPattern().regex("[^,)]+")}).sequence(new Object[]{CsShallowParser.VALID_IDENTIFIERS}).group(0).alternative(new Object[]{new TokenPattern().sequence(new Object[]{ETokenType.COMMA}), new TokenPattern().sequence(new Object[]{ETokenType.RPAREN})});
                break;
            }
            default: {
                LogManager.getLogger().error("Language '{}' not supported!", (Object)this.language.getReadableName());
            }
        }
    }

    protected void processEntity(ShallowEntity entity) throws CheckException {
        if (ANONYMOUS_FUNCTION_SUBTYPE_NAMES.contains(entity.getSubtype())) {
            return;
        }
        if (this.modifier == ETokenType.OUT && TokenStreamUtils.contains((List)entity.ownStartTokens(), (ETokenType)ETokenType.EXTERN)) {
            return;
        }
        List<String> modifiedParameters = this.getModifiedTokens(entity).stream().map(IToken::getText).toList();
        TokenPatternMatch methodDeclaration = METHOD_DECLARATION_PATTERN.findFirstMatch((List)entity.ownStartTokens());
        CCSMAssert.isNotNull((Object)methodDeclaration);
        String methodName = ((IToken)((MatchGroupElement)methodDeclaration.getMatchGroup(1).getFirst()).getTokens().getFirst()).getText();
        for (String parameter : modifiedParameters) {
            String message = String.format("Avoid `%s` for parameter `%s` in method `%s`", this.modifier.name().toLowerCase(), parameter, methodName);
            this.buildFinding(message, this.buildLocation().forEntityFirstLine(entity)).createAndStore();
        }
    }

    protected List<IToken> getModifiedTokens(ShallowEntity entity) {
        return this.modifiedParametersPattern.findAll((List)entity.ownStartTokens()).stream().map(match -> (IToken)((MatchGroupElement)match.getMatchGroup(0).getFirst()).getTokens().get(0)).toList();
    }
}

