/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.formatting;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.regex.Pattern;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-long-line", languages={ELanguage.JAVA, ELanguage.ADA, ELanguage.CS, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.PLSQL, ELanguage.ABAP, ELanguage.JAVASCRIPT, ELanguage.PYTHON, ELanguage.DELPHI, ELanguage.MATLAB, ELanguage.FORTRAN, ELanguage.IEC61131, ELanguage.XTEND, ELanguage.OCAML, ELanguage.TSQL, ELanguage.GROOVY, ELanguage.PHP, ELanguage.SQLSCRIPT, ELanguage.OPEN_CL, ELanguage.RUST, ELanguage.VB, ELanguage.SWIFT, ELanguage.GOSU, ELanguage.OSCRIPT, ELanguage.COBOL, ELanguage.KOTLIN, ELanguage.LINE, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP, ELanguage.ESQL, ELanguage.GO})
public class LongLineCheck
extends CheckImplementationBase {
    private static final Pattern TRAILING_SPACE = Pattern.compile("\\s+$");
    @CheckOption(name="Long lines: ignore trailing space", description="If this is true, spaces at the end of the line are not counted.")
    private boolean ignoreTrailingSpace = true;
    @CheckOption(name="Long lines: maximal length", description="The maximal length of the lines in characters.")
    private int longLinesMaxLength = 120;

    public void execute() throws CheckException {
        String[] lines = StringUtils.splitLines((String)this.context.getTextContent(ECodeViewOption.ETextViewOption.FILTERED_CONTENT));
        for (int currentLine = 0; currentLine < lines.length; ++currentLine) {
            String line = lines[currentLine];
            if (this.ignoreTrailingSpace) {
                line = TRAILING_SPACE.matcher(line).replaceAll("");
            }
            int lineNumber = currentLine + 1;
            if (line.length() <= this.longLinesMaxLength) continue;
            this.buildFinding("Violation of Line length of " + this.longLinesMaxLength + ": " + line.length(), this.buildLocation().forLine(lineNumber)).createAndStore();
        }
    }
}

