/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.formatting;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.preprocessor.c.CPreprocessor;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.shallowparser.util.ConnectedEntityCollector;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-multiple-statements-per-line", languages={ELanguage.JAVA, ELanguage.ADA, ELanguage.CS, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.PLSQL, ELanguage.JAVASCRIPT, ELanguage.PYTHON, ELanguage.DELPHI, ELanguage.MATLAB, ELanguage.FORTRAN, ELanguage.IEC61131, ELanguage.XTEND, ELanguage.OCAML, ELanguage.TSQL, ELanguage.GROOVY, ELanguage.PHP, ELanguage.SQLSCRIPT, ELanguage.OPEN_CL, ELanguage.RUST, ELanguage.VB, ELanguage.SWIFT, ELanguage.GOSU, ELanguage.OSCRIPT, ELanguage.COBOL, ELanguage.KOTLIN, ELanguage.LINE, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP, ELanguage.ESQL, ELanguage.GO}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class MultipleStatementsPerLineCheck
extends CheckImplementationBase {
    private static final EnumSet<ETokenType> PLSQL_AGGREGATE_FUNCTIONS = EnumSet.of(ETokenType.AVG, new ETokenType[]{ETokenType.COLLECT, ETokenType.COUNT, ETokenType.MAX, ETokenType.MIN, ETokenType.STDDEV, ETokenType.SUM, ETokenType.VARIANCE});
    private static final String FINDING_MESSAGE = "Multiple statements in single line";

    public void execute() throws CheckException {
        this.analyzeConnectedEntityGroupsByType(EShallowEntityType.STATEMENT, MultipleStatementsPerLineCheck::isBlockForCaseStatement);
        this.analyzeConnectedEntityGroupsByType(EShallowEntityType.ATTRIBUTE, MultipleStatementsPerLineCheck::isEnumLiteral);
        this.analyzeBlockStatements();
    }

    private static boolean isEnumLiteral(ShallowEntity statement) {
        return !"enum literal".equals(statement.getSubtype());
    }

    private static boolean isBlockForCaseStatement(ShallowEntity statement) {
        boolean isAnonymousBlock = "anonymous block".equals(statement.getSubtype());
        boolean isInsideSwitchStatement = statement.getParent() != null && "switch".equals(statement.getParent().getSubtype());
        return !isAnonymousBlock || !isInsideSwitchStatement;
    }

    private void analyzeConnectedEntityGroupsByType(EShallowEntityType entityType, Predicate<ShallowEntity> statementSelector) throws CheckException {
        ConnectedEntityCollector collector = new ConnectedEntityCollector(entityType, statement -> statement.isCompleted() && statementSelector.test((ShallowEntity)statement));
        for (List connectedStatementGroup : collector.getConnectedGroups(this.context.getAbstractSyntaxTree(ECodeViewOption.FILTERED_PREPROCESSED))) {
            this.analyzeConnectedEntityGroup(connectedStatementGroup);
        }
    }

    private void analyzeConnectedEntityGroup(List<ShallowEntity> primitiveStatements) {
        HashSet<Integer> reportedLines = new HashSet<Integer>();
        for (int i = 1; i < primitiveStatements.size(); ++i) {
            int lineNumber;
            ShallowEntity statement1 = primitiveStatements.get(i - 1);
            ShallowEntity statement2 = primitiveStatements.get(i);
            if (statement2.getStartLine() > statement1.getEndLine() || statement1.isContinued() || this.ignoreConsecutiveStatements(statement1, statement2) || !reportedLines.add(lineNumber = statement2.getStartLine())) continue;
            this.buildFinding(FINDING_MESSAGE, this.buildLocation().forLine(lineNumber)).createAndStore();
        }
    }

    private void analyzeBlockStatements() throws CheckException {
        List<ShallowEntity> blockEntities = MultipleStatementsPerLineCheck.filterMacros(new ShallowEntityTraversalUtils.CollectingVisitorBase(this){
            final /* synthetic */ MultipleStatementsPerLineCheck this$0;
            {
                MultipleStatementsPerLineCheck multipleStatementsPerLineCheck = this$0;
                Objects.requireNonNull(multipleStatementsPerLineCheck);
                this.this$0 = multipleStatementsPerLineCheck;
            }

            protected boolean collect(ShallowEntity entity) {
                return this.this$0.isRelevantBlockEntity(entity);
            }
        }.apply((Collection)this.context.getAbstractSyntaxTree(ECodeViewOption.FILTERED_PREPROCESSED)));
        for (ShallowEntity blockEntity : blockEntities) {
            if (blockEntity.getStartLine() != ((ShallowEntity)blockEntity.getChildren().get(0)).getStartLine() || this.ignoreConsecutiveStatements(blockEntity, (ShallowEntity)blockEntity.getChildren().get(0)) || this.ignoreCommonBlockPattern(blockEntity)) continue;
            this.buildFinding(FINDING_MESSAGE, this.buildLocation().forLine(blockEntity.getStartLine())).createAndStore();
        }
    }

    private boolean isRelevantBlockEntity(ShallowEntity entity) {
        if (entity.getType() == EShallowEntityType.STATEMENT && entity.hasChildren() && ((IToken)entity.getAllTokensOfFile().get(((ShallowEntity)entity.getChildren().get(0)).getStartTokenIndex() - 1)).getType() == ETokenType.LBRACE) {
            int expectedIdentifierPosition = ((ShallowEntity)entity.getChildren().get(0)).getStartTokenIndex() - 2;
            return !this.context.getLanguage().isCppOrObjectiveCpp() || expectedIdentifierPosition < 0 || expectedIdentifierPosition >= entity.getAllTokensOfFile().size() || ((IToken)entity.getAllTokensOfFile().get(expectedIdentifierPosition)).getType() != ETokenType.IDENTIFIER;
        }
        return false;
    }

    private boolean isPartOfJavascriptExportStatement(ShallowEntity entity) {
        if (this.context.getLanguage() != ELanguage.JAVASCRIPT) {
            return false;
        }
        for (ShallowEntity current = entity; current != null; current = current.getParent()) {
            if (current.getType() != EShallowEntityType.STATEMENT || !current.getSubtype().equals("nodejs module.exports")) continue;
            return true;
        }
        return false;
    }

    private boolean ignoreCommonBlockPattern(ShallowEntity blockEntity) {
        if (this.isPartOfJavascriptExportStatement(blockEntity)) {
            return true;
        }
        ELanguage language = TokenStreamUtils.getLanguage((Collection)blockEntity.includedTokens());
        if (language == ELanguage.SWIFT) {
            return "guard".equals(blockEntity.getSubtype()) && "simple statement".equals(((ShallowEntity)blockEntity.getChildren().get(0)).getSubtype());
        }
        if (language == ELanguage.GROOVY) {
            return ((IToken)blockEntity.getAllTokensOfFile().get(((ShallowEntity)blockEntity.getChildren().get(0)).getStartTokenIndex() - 2)).getType() == ETokenType.IDENTIFIER;
        }
        return false;
    }

    protected boolean ignoreConsecutiveStatements(ShallowEntity statement1, ShallowEntity statement2) {
        if (statement1.isEmpty()) {
            return true;
        }
        UnmodifiableList includedTokens1 = statement1.includedTokens();
        ELanguage language = TokenStreamUtils.getLanguage((Collection)includedTokens1);
        if (language == null) {
            return true;
        }
        UnmodifiableList includedTokens2 = statement2.includedTokens();
        return this.shouldStatementBeIgnored(statement1, statement2, language, (UnmodifiableList<IToken>)includedTokens1, (UnmodifiableList<IToken>)includedTokens2);
    }

    private boolean shouldStatementBeIgnored(ShallowEntity statement1, ShallowEntity statement2, ELanguage language, UnmodifiableList<IToken> includedTokens1, UnmodifiableList<IToken> includedTokens2) {
        if (MultipleStatementsPerLineCheck.belongsToDifferentBlocks(statement1, statement2)) {
            return true;
        }
        switch (language) {
            case ADA: 
            case COBOL: {
                return MultipleStatementsPerLineCheck.isWhenStatement(statement1);
            }
            case PLSQL: {
                return MultipleStatementsPerLineCheck.isCommaSeparatedListPLSQL(statement1, statement2, includedTokens1, includedTokens2);
            }
            case KOTLIN: {
                return MultipleStatementsPerLineCheck.isKotlinConstructorParameter(statement1, statement2, includedTokens1);
            }
            case ABAP: {
                LogManager.getLogger().error("MultipleStatementsPerLineCheck called for ABAP file. Should use the AbapMultipleStatementsPerLineCheck instead. " + this.context.getUniformPath());
                return false;
            }
            case CPP: 
            case CPP_MS_CLI: 
            case C: 
            case OBJECTIVE_CPP: 
            case OBJECTIVE_C: {
                return MultipleStatementsPerLineCheck.isEmptyStatement(statement1, statement2) || MultipleStatementsPerLineCheck.isMacroGeneratedStatements(statement1, statement2);
            }
        }
        return false;
    }

    private static boolean isMacroGeneratedStatements(ShallowEntity statement1, ShallowEntity statement2) {
        return (CollectionUtils.anyMatch((Collection)statement1.includedTokens(), (Predicate)CPreprocessor.IS_MACRO_TOKEN) || CollectionUtils.anyMatch((Collection)statement2.includedTokens(), (Predicate)CPreprocessor.IS_MACRO_TOKEN)) && statement1.getStartOffset() == statement2.getStartOffset();
    }

    private static boolean isEmptyStatement(ShallowEntity statement1, ShallowEntity statement2) {
        return statement2.getSubtype().equals("empty statement") || statement1.getSubtype().equals("empty statement");
    }

    private static List<ShallowEntity> filterMacros(List<ShallowEntity> statements) {
        return statements.stream().filter(statement -> !statement.isEmpty()).filter(statement -> !CollectionUtils.anyMatch((Collection)statement.includedTokens(), (Predicate)CPreprocessor.IS_MACRO_TOKEN)).toList();
    }

    private static boolean isWhenStatement(ShallowEntity statement1) {
        return "when".equals(statement1.getSubtype());
    }

    private static boolean isKotlinConstructorParameter(ShallowEntity statement1, ShallowEntity statement2, UnmodifiableList<IToken> includedTokens1) {
        return statement1.getType() == EShallowEntityType.ATTRIBUTE && statement2.getType() == EShallowEntityType.ATTRIBUTE && TokenStreamUtils.endsWith(includedTokens1, (ETokenType[])new ETokenType[]{ETokenType.COMMA});
    }

    private static boolean belongsToDifferentBlocks(ShallowEntity statement1, ShallowEntity statement2) {
        return statement1.hasChildren() && !statement1.getChildren().contains((Object)statement2);
    }

    private static boolean isCommaSeparatedListPLSQL(ShallowEntity statement1, ShallowEntity statement2, UnmodifiableList<IToken> includedTokens1, UnmodifiableList<IToken> includedTokens2) {
        return statement1.getSubtype().equals("variable") && statement2.getSubtype().equals("variable") && TokenStreamUtils.endsWith(includedTokens1, (ETokenType[])new ETokenType[]{ETokenType.COMMA}) && MultipleStatementsPerLineCheck.isPlsqlListElement(includedTokens2);
    }

    private static boolean isPlsqlListElement(List<IToken> tokens) {
        ETokenType firstTokenType = tokens.get(0).getType();
        return firstTokenType == ETokenType.IDENTIFIER || PLSQL_AGGREGATE_FUNCTIONS.contains(firstTokenType);
    }
}

