/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.general;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.preprocessor.PreprocessorFactory;
import eu.cqse.check.framework.preprocessor.c.CPreprocessor;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.TokenUtils;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableSet;

public abstract class EmptyBlockCheckBase
extends CheckImplementationBase {
    private static final UnmodifiableSet<String> STATEMENT_SUBTYPES_ENDING_WITH_BLOCK = CollectionUtils.asUnmodifiableHashSet((Object[])new String[]{"if", "else", "else if", "switch", "switch expression", "for", "foreach", "while", "anonymous block", "with", "try", "catch", "finally", "lock", "synchronized", "fixed", "using", "checked", "unchecked", "unsafe"});

    public void execute() throws CheckException {
        UnmodifiableList fileTokens = this.context.getTokens(ECodeViewOption.FILTERED_PREPROCESSED);
        for (ShallowEntity entity : ShallowEntityTraversalUtils.listAllEntities((Collection)this.context.getAbstractSyntaxTree(ECodeViewOption.FILTERED_PREPROCESSED))) {
            int closingBraceOffset;
            int openingBraceOffset;
            Pair<IToken, IToken> braceTokens;
            if (!this.shouldReport((List<IToken>)fileTokens, entity) || entity.hasChildren() || (braceTokens = EmptyBlockCheckBase.getBracesOfBlockIfEmpty(entity)) == null || EmptyBlockCheckBase.isCppMacroGeneratedToken((IToken)braceTokens.getFirst()) || EmptyBlockCheckBase.isCppMacroGeneratedToken((IToken)braceTokens.getSecond()) || EmptyBlockCheckBase.containsCommentsBetweenOffsets((List<IToken>)fileTokens, openingBraceOffset = ((IToken)braceTokens.getFirst()).getOffset(), closingBraceOffset = ((IToken)braceTokens.getSecond()).getOffset()) || this.containsCodeBetweenOffsetsBeforePreprocessing(openingBraceOffset, closingBraceOffset)) continue;
            this.buildFinding(this.constructMessage(entity), this.buildLocation().betweenOffsets(openingBraceOffset, closingBraceOffset, ECodeViewOption.ETextViewOption.FILTERED_CONTENT)).createAndStore();
        }
    }

    private static boolean isCppMacroGeneratedToken(IToken token) {
        return PreprocessorFactory.C_PREPROCESSOR_LANGUAGES.contains(token.getLanguage()) && CPreprocessor.IS_MACRO_TOKEN.test(token);
    }

    private boolean containsCodeBetweenOffsetsBeforePreprocessing(int startOffset, int endOffset) throws CheckException {
        UnmodifiableList unpreprocessedTokens = this.context.getTokens(ECodeViewOption.FILTERED);
        int startIndex = TokenStreamUtils.indexOfByOffset((List)unpreprocessedTokens, (int)startOffset);
        return startIndex + 1 < unpreprocessedTokens.size() && ((IToken)unpreprocessedTokens.get(startIndex + 1)).getOffset() != endOffset;
    }

    private static Pair<IToken, IToken> getBracesOfBlockIfEmpty(ShallowEntity entity) {
        if (EmptyBlockCheckBase.isEntityThatBeginsWithBlock(entity)) {
            return EmptyBlockCheckBase.getBracesOfEmptyBlockAtBeginning(entity);
        }
        if (EmptyBlockCheckBase.isEntityThatEndsWithBlock(entity)) {
            return EmptyBlockCheckBase.getBracesOfEmptyBlockAtEnd(entity);
        }
        return null;
    }

    private static boolean isEntityThatBeginsWithBlock(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.STATEMENT && "do".equals(entity.getSubtype());
    }

    private static boolean isEntityThatEndsWithBlock(ShallowEntity entity) {
        switch (entity.getType()) {
            case MODULE: 
            case TYPE: {
                return true;
            }
            case METHOD: {
                return !"abstract".equals(entity.getSubtype());
            }
            case STATEMENT: {
                return STATEMENT_SUBTYPES_ENDING_WITH_BLOCK.contains((Object)entity.getSubtype());
            }
        }
        return false;
    }

    private static Pair<IToken, IToken> getBracesOfEmptyBlockAtBeginning(ShallowEntity entity) {
        UnmodifiableList entityTokens = entity.includedTokens();
        int openingBraceIndex = TokenStreamUtils.firstTokenMatching((List)entityTokens, (ITokenMatcher)ETokenType.LBRACE);
        if (openingBraceIndex == -1) {
            return null;
        }
        if (openingBraceIndex != 0 && openingBraceIndex != 1) {
            return null;
        }
        int closingBraceIndex = TokenStreamUtils.firstTokenMatching((List)entityTokens, (ITokenMatcher)ETokenType.RBRACE);
        if (closingBraceIndex == -1) {
            return null;
        }
        if (openingBraceIndex != closingBraceIndex - 1) {
            return null;
        }
        return Pair.createPair((Object)((IToken)entityTokens.get(openingBraceIndex)), (Object)((IToken)entityTokens.get(closingBraceIndex)));
    }

    private static Pair<IToken, IToken> getBracesOfEmptyBlockAtEnd(ShallowEntity entity) {
        UnmodifiableList entityTokens = entity.includedTokens();
        int closingBraceIndex = TokenStreamUtils.lastTokenMatching((List)entityTokens, (ITokenMatcher)ETokenType.RBRACE);
        if (closingBraceIndex == -1) {
            return null;
        }
        if (closingBraceIndex != entityTokens.size() - 1 && closingBraceIndex != entityTokens.size() - 2) {
            return null;
        }
        int openingBraceIndex = TokenStreamUtils.lastTokenMatching((List)entityTokens, (ITokenMatcher)ETokenType.LBRACE);
        if (openingBraceIndex == -1) {
            return null;
        }
        if (openingBraceIndex != closingBraceIndex - 1) {
            return null;
        }
        if (openingBraceIndex > 0 && ((IToken)entityTokens.get(openingBraceIndex - 1)).getType() == ETokenType.RBRACK) {
            return null;
        }
        return Pair.createPair((Object)((IToken)entityTokens.get(openingBraceIndex)), (Object)((IToken)entityTokens.get(closingBraceIndex)));
    }

    private static boolean containsCommentsBetweenOffsets(List<IToken> rawTokens, int startOffset, int endOffset) {
        boolean active = false;
        for (IToken token : rawTokens) {
            if (token.getOffset() == startOffset) {
                active = true;
                continue;
            }
            if (active && TokenUtils.isCommentToken((IToken)token)) {
                return true;
            }
            if (token.getOffset() != endOffset) continue;
            return false;
        }
        CCSMAssert.fail((String)"Didn't find a token with endOffset");
        return false;
    }

    protected abstract boolean shouldReport(List<IToken> var1, ShallowEntity var2);

    protected abstract String constructMessage(ShallowEntity var1);
}

