/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.hana_views;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.hana_views.HanaViewsCheckUtil;
import eu.cqse.check.xml.XmlCheckBase;
import eu.cqse.check.xml.XmlCheckHandlerBase;
import eu.cqse.check.xml.XmlElementAttributesCheckHandlerBase;
import java.util.Objects;
import org.xml.sax.Attributes;

@Check(id="cqse-scripted-calculation-view-naming", languages={ELanguage.HANA_VIEW})
public class ScriptedCalculationViewNamingCheck
extends XmlCheckBase {
    private static final String CHECK_NAME = "Naming of scripted calculation views";
    @CheckOption(name="Naming of scripted calculation views - required naming pattern", description="Regular expression for the naming pattern.")
    private String namingPatternRegex = ".*_SQL$";
    private static final String ELEMENT_CALCULATION_VIEW = "calculationView";
    private static final String ATTRIBUTE_XSI_TYPE = "xsi:type";
    private static final String VALUE_XSI_TYPE_SCRIPTED_CALCULATION_VIEWS = "Calculation:SqlScriptView";

    @Override
    public XmlCheckHandlerBase getHandler() {
        return new XmlElementAttributesCheckHandlerBase(this, ELEMENT_CALCULATION_VIEW){
            final /* synthetic */ ScriptedCalculationViewNamingCheck this$0;
            {
                ScriptedCalculationViewNamingCheck scriptedCalculationViewNamingCheck = this$0;
                Objects.requireNonNull(scriptedCalculationViewNamingCheck);
                this.this$0 = scriptedCalculationViewNamingCheck;
                super(xmlElementName);
            }

            @Override
            protected void checkAttributes(Attributes attributes) {
                String attributeValue = attributes.getValue(ScriptedCalculationViewNamingCheck.ATTRIBUTE_XSI_TYPE);
                if (ScriptedCalculationViewNamingCheck.VALUE_XSI_TYPE_SCRIPTED_CALCULATION_VIEWS.equals(attributeValue)) {
                    this.checkFileExtension();
                }
            }

            private void checkFileExtension() {
                String objectName = HanaViewsCheckUtil.getRepositoryObjectName(this.this$0.context);
                if (!objectName.matches(this.this$0.namingPatternRegex)) {
                    this.createElementFinding("Scripted calculation view '" + objectName + "' violates naming pattern '" + this.this$0.namingPatternRegex + "'");
                }
            }
        };
    }
}

