/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="java:S6809", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AsyncMethodsCalledViaThisCheck
extends CheckImplementationBase {
    private static final int GROUP_METHOD_NAME = 0;
    private static final TokenPattern IMPLICIT_THIS_CALL_PATTERN = TokenPattern.of().notPrecededBy((Object)ETokenType.DOT).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).sequence(new Object[]{ETokenType.LPAREN});
    private static final TokenPattern EXPLICIT_THIS_CALL_PATTERN = TokenPattern.of().sequence(new Object[]{ETokenType.THIS, ETokenType.DOT.or(new ITokenMatcher[]{ETokenType.DOUBLE_COLON})}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0);
    private static final Map<String, String> ANNOTATION_MESSAGE_TYPE = Map.of("org.springframework.scheduling.annotation.Async", "async", "Async", "async", "org.springframework.transaction.annotation.Transactional", "transactional", "Transactional", "transactional");

    public void execute() throws CheckException {
        this.context.getAbstractSyntaxTree(this.getCodeViewOption()).stream().filter(entity -> EShallowEntityType.TYPE == entity.getType() && "class".equals(entity.getSubtype())).forEach(this::analyzeClass);
    }

    private void analyzeClass(ShallowEntity classEntity) {
        List methodEntities = ShallowEntityTraversalUtils.listEntitiesOfTypeNonRecursive((Collection)classEntity.getChildren(), (EShallowEntityType)EShallowEntityType.METHOD);
        Map<ShallowEntity, String> annotatedMethodsEntity = AsyncMethodsCalledViaThisCheck.findAnnotatedMethods(methodEntities);
        if (annotatedMethodsEntity.isEmpty()) {
            return;
        }
        Set unannotatedNames = methodEntities.stream().filter(m -> !annotatedMethodsEntity.containsKey(m)).map(ShallowEntity::getName).collect(Collectors.toSet());
        Map<String, String> annotatedMethods = annotatedMethodsEntity.entrySet().stream().filter(e -> !unannotatedNames.contains(((ShallowEntity)e.getKey()).getName())).collect(Collectors.toMap(e -> ((ShallowEntity)e.getKey()).getName(), Map.Entry::getValue, (v1, v2) -> v1));
        if (annotatedMethods.isEmpty()) {
            return;
        }
        methodEntities.forEach(method -> this.findViolationsInMethod((ShallowEntity)method, annotatedMethods));
    }

    private static Map<ShallowEntity, String> findAnnotatedMethods(List<ShallowEntity> methodEntities) {
        return methodEntities.stream().flatMap(AsyncMethodsCalledViaThisCheck::getAnnotatedMethodAsStream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Stream<Map.Entry<ShallowEntity, String>> getAnnotatedMethodAsStream(ShallowEntity method) {
        return LanguageFeatureParser.JAVA.getAnnotations(method).stream().map(annotation -> ANNOTATION_MESSAGE_TYPE.get(annotation.getName())).filter(Objects::nonNull).findFirst().map(type -> Map.entry(method, type)).stream();
    }

    private void findViolationsInMethod(ShallowEntity method, Map<String, String> annotatedMethods) {
        UnmodifiableList children = method.getChildren();
        if (children.isEmpty()) {
            return;
        }
        int startTokenIndex = ((ShallowEntity)children.getFirst()).getStartTokenIndex();
        int endTokenIndex = ((ShallowEntity)children.getLast()).getEndTokenIndex();
        List methodTokens = method.getAllTokensOfFile().subList(startTokenIndex, endTokenIndex);
        Stream.of(IMPLICIT_THIS_CALL_PATTERN, EXPLICIT_THIS_CALL_PATTERN).flatMap(pattern -> pattern.findNonOverlappingMatches(methodTokens).stream()).forEach(match -> this.checkAndReportViolation((TokenPatternMatch)match, annotatedMethods));
    }

    private void checkAndReportViolation(TokenPatternMatch match, Map<String, String> annotatedMethods) {
        String calledMethodName = match.groupString(0);
        String annotationType = annotatedMethods.get(calledMethodName);
        if (annotationType != null) {
            IToken locationToken = (IToken)match.groupTokens(0).getFirst();
            String message = String.format("Call to %s method should be done via an injected proxy, not 'this'", annotationType);
            this.buildFinding(message, this.buildLocation().forToken(locationToken)).createAndStore();
        }
    }
}

