/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ScopedTypeLookup;
import java.net.URL;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="cqse-avoid-using-unchecked-url", languages={ELanguage.JAVA})
public class AvoidUsingUncheckedUrlCheck
extends CheckImplementationBase {
    private static final Set<String> VULNERABLE_METHODS = Set.of("getContent", "openConnection", "openStream");
    private static final String FINDINGS_MESSAGE = "Using of an unchecked " + MarkupUtils.formatAsSourceCode((String)"URL") + " object can be insecure";
    private static final int SPLIT_LIMIT = 2;

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfTypes((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), EnumSet.of(EShallowEntityType.STATEMENT));
        HashSet<String> urlVariables = new HashSet<String>();
        for (ShallowEntity statement : statements) {
            UnmodifiableList tokens = statement.ownStartTokens();
            ScopedTypeLookup typeLookup = this.context.getTypeResolution(ECodeViewOption.FILTERED).getTypeLookup(statement);
            this.findUrlVariable(typeLookup, (List<IToken>)tokens).ifPresent(urlVariables::add);
            this.checkUrlVariables((List<IToken>)tokens, urlVariables);
            this.checkSingleLineStatements(typeLookup, (List<IToken>)tokens);
        }
    }

    private Optional<String> findUrlVariable(ScopedTypeLookup typeLookup, List<IToken> tokens) {
        List<IToken> constructor;
        int index = TokenStreamUtils.firstTokenOfTypeSequence(tokens, (int)0, (int)tokens.size(), (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.EQ, ETokenType.NEW, ETokenType.IDENTIFIER, ETokenType.LPAREN});
        if (index != -1 && this.isUrlConstructor(constructor = tokens.subList(index + 2, tokens.size())) && this.hasVulnerableParameter(typeLookup, constructor)) {
            String variable = tokens.get(index).getText();
            return Optional.of(variable);
        }
        return Optional.empty();
    }

    private void checkUrlVariables(List<IToken> tokens, Collection<String> urlVariables) {
        List indices = TokenStreamUtils.firstTokenOfTypeSequences(tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.DOT, ETokenType.IDENTIFIER, ETokenType.LPAREN});
        for (Integer index : indices) {
            IToken object = tokens.get(index);
            IToken method = tokens.get(index + 2);
            if (!urlVariables.contains(object.getText())) continue;
            if (VULNERABLE_METHODS.contains(method.getText())) {
                this.buildFinding(FINDINGS_MESSAGE, this.buildLocation().forToken(object)).createAndStore();
                continue;
            }
            urlVariables.remove(object.getText());
        }
    }

    private void checkSingleLineStatements(ScopedTypeLookup typeLookup, List<IToken> tokens) {
        List indices = TokenStreamUtils.firstTokenOfTypeSequences(tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.NEW, ETokenType.IDENTIFIER, ETokenType.LPAREN});
        for (Integer index : indices) {
            String methodName;
            List splitTokens = TokenStreamUtils.splitWithNesting(tokens.subList(index, tokens.size()), Set.of(ETokenType.DOT), List.of(ETokenType.LPAREN), List.of(ETokenType.RPAREN), (int)2);
            if (splitTokens.size() != 2) continue;
            List constructor = (List)splitTokens.get(0);
            List methodCall = (List)splitTokens.get(1);
            if (!this.isUrlConstructor(constructor) || !this.hasVulnerableParameter(typeLookup, constructor) || !this.isMethodCall(methodCall) || !VULNERABLE_METHODS.contains(methodName = ((IToken)methodCall.get(0)).getText())) continue;
            this.buildFinding(FINDINGS_MESSAGE, this.buildLocation().forToken((IToken)constructor.get(1))).createAndStore();
        }
    }

    private boolean isUrlConstructor(List<IToken> constructor) {
        if (constructor.size() < 5) {
            return false;
        }
        return URL.class.getSimpleName().equals(constructor.get(1).getText());
    }

    private boolean hasVulnerableParameter(ScopedTypeLookup typeLookup, List<IToken> constructor) {
        List<IToken> parameter = constructor.subList(3, constructor.size());
        boolean hasVariableInParameter = parameter.stream().filter(token -> token.getType().isIdentifier()).map(IToken::getText).anyMatch(text -> typeLookup.getTypeInfo(text) != null);
        boolean hasStringLiteral = parameter.stream().map(IToken::getType).anyMatch(arg_0 -> ETokenType.STRING_LITERAL.equals(arg_0));
        boolean hasMethodInParameter = parameter.stream().filter(token -> token.getType().isIdentifier()).map(IToken::getText).anyMatch(text -> typeLookup.getTypeInfo(text) == null);
        return hasVariableInParameter || !hasStringLiteral && hasMethodInParameter;
    }

    private boolean isMethodCall(List<IToken> methodCall) {
        return methodCall.size() >= 3 && TokenStreamUtils.hasTokenTypeSequence(methodCall, (int)0, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.LPAREN});
    }
}

