/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.JavaMethodCallMatcher;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.conqat.lib.commons.collections.CollectionUtils;

@Check(id="java:S3329", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class CipherBlockChainingCheck
extends CheckImplementationBase {
    private static final String IV_PARAMETER_SPEC_NAME = "IvParameterSpec";
    private static final String FULL_QUALIFIER = "javax.crypto.spec.IvParameterSpec";
    private static final ITokenMatcher IV_PARAMETER_MATCHER = ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"IvParameterSpec"})});
    private static final ITokenMatcher GENERATE_SEED_MATCHER = ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"generateSeed"})});
    private static final ITokenMatcher NEXT_BYTES_MATCHER = ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"nextBytes"})});
    private static final ITokenMatcher GET_MATCHER = ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"get"})});
    private static final TokenPattern IV_CONSTRUCTOR_PATTERN = new TokenPattern().sequence(new Object[]{IV_PARAMETER_MATCHER, ETokenType.LPAREN}).sequence(new Object[]{ETokenType.IDENTIFIER, new TokenPattern().repeated(new Object[]{ETokenType.DOT, ETokenType.IDENTIFIER})}).group(0);
    private static final TokenPattern DYNAMIC_IV_CONSTRUCTOR_PATTERN = new TokenPattern().sequence(new Object[]{IV_PARAMETER_MATCHER, ETokenType.LPAREN}).sequence(new Object[]{ETokenType.IDENTIFIER, ETokenType.DOT, GENERATE_SEED_MATCHER});
    private static final TokenPattern STATIC_IV_PATTERN = new TokenPattern().alternative(new Object[]{new TokenPattern().sequence(new Object[]{new TokenPattern().alternative(new Object[]{ETokenType.STRING_LITERAL, ETokenType.IDENTIFIER}), ETokenType.DOT, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"getBytes"})}), ETokenType.LPAREN}), new TokenPattern().sequence(new Object[]{ETokenType.NEW, ETokenType.BYTE})});
    private static final JavaMethodCallMatcher CONSTRUCTOR_CALL_MATCHER = JavaMethodCallMatcher.create().constructors().onTypes(new String[]{"javax.crypto.spec.IvParameterSpec"}).withParameterMinCount(1);

    public void execute() throws CheckException {
        List ast = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        if (CipherBlockChainingCheck.containsNoCryptoImport(ast)) {
            return;
        }
        JavaImportSensitiveTypeResolver typeResolver = new JavaImportSensitiveTypeResolver(this.context.getRootEntity(this.getCodeViewOption()));
        for (JavaMethodCallMatcher.MethodCall constructorCall : CONSTRUCTOR_CALL_MATCHER.find(this.context, typeResolver)) {
            if (constructorCall.entity().getType() != EShallowEntityType.STATEMENT) continue;
            this.analyzeConstructorCall(constructorCall.entity());
        }
    }

    private static boolean containsNoCryptoImport(List<ShallowEntity> ast) {
        return LanguageFeatureParser.JAVA.getImportsByPrefix(ast, new String[]{FULL_QUALIFIER}).isEmpty();
    }

    private void analyzeConstructorCall(ShallowEntity constructorCall) {
        if (CipherBlockChainingCheck.isDynamicConstructor(constructorCall) || CipherBlockChainingCheck.isMethodParameter(constructorCall) || CipherBlockChainingCheck.hasDynamicAssignment(constructorCall) || CipherBlockChainingCheck.isUsedForDecryption(constructorCall)) {
            return;
        }
        this.createFinding(constructorCall);
    }

    private static boolean isUsedForDecryption(ShallowEntity statementWithConstructorCall) {
        ArrayList<IToken> tokens = new ArrayList<IToken>((Collection<IToken>)statementWithConstructorCall.includedTokens());
        if (CipherBlockChainingCheck.statementContainsDecryption(tokens)) {
            return true;
        }
        int eqIndex = CollectionUtils.indexOfFirstMatch(tokens, token -> token.getType() == ETokenType.EQ);
        if (eqIndex == -1) {
            return false;
        }
        List variableTokens = tokens.subList(0, eqIndex);
        String variableName = statementWithConstructorCall.getName();
        if (variableTokens.isEmpty()) {
            return false;
        }
        ShallowEntity nextStatement = ShallowEntityTraversalUtils.getSubsequentSiblingEntity((ShallowEntity)statementWithConstructorCall);
        while (nextStatement != null) {
            if (CipherBlockChainingCheck.statementContainsDecryption((List<IToken>)nextStatement.includedTokens()) && nextStatement.includedTokens().stream().anyMatch(token -> token.getType() == ETokenType.IDENTIFIER && token.getText().equals(variableName))) {
                return true;
            }
            nextStatement = ShallowEntityTraversalUtils.getSubsequentSiblingEntity((ShallowEntity)nextStatement);
        }
        return false;
    }

    private static boolean statementContainsDecryption(List<IToken> tokens) {
        return tokens.stream().anyMatch(token -> token.getType() == ETokenType.IDENTIFIER && token.getText().equals("DECRYPT_MODE"));
    }

    private static boolean isDynamicConstructor(ShallowEntity constructor) {
        return DYNAMIC_IV_CONSTRUCTOR_PATTERN.matchesAnywhere((List)constructor.ownStartTokens());
    }

    private static boolean isMethodParameter(ShallowEntity constructor) {
        TokenPatternMatch match = IV_CONSTRUCTOR_PATTERN.findFirstMatch((List)constructor.ownStartTokens());
        if (match == null) {
            return false;
        }
        TokenPattern qualifierPattern = CipherBlockChainingCheck.buildQualifierPattern(match.groupTokens(0));
        Optional method = ShallowEntityTraversalUtils.findEntityOrParentEntity((ShallowEntity)constructor, entity -> entity.getType() == EShallowEntityType.METHOD);
        return method.isPresent() && qualifierPattern.matchesAnywhere((List)((ShallowEntity)method.get()).ownStartTokens());
    }

    private static boolean hasDynamicAssignment(ShallowEntity constructor) {
        TokenPatternMatch match = IV_CONSTRUCTOR_PATTERN.findFirstMatch((List)constructor.ownStartTokens());
        if (match == null) {
            return false;
        }
        TokenPattern qualifierPattern = CipherBlockChainingCheck.buildQualifierPattern(match.groupTokens(0));
        ShallowEntity predecessor = ShallowEntityTraversalUtils.getPreviousEntity((ShallowEntity)constructor);
        while (predecessor != null && predecessor.getType() != EShallowEntityType.METHOD) {
            if (CipherBlockChainingCheck.staticAssignment(qualifierPattern).matchesAnywhere((List)predecessor.ownStartTokens())) {
                return false;
            }
            if (CipherBlockChainingCheck.dynamicAssignment(qualifierPattern).matchesAnywhere((List)predecessor.ownStartTokens())) {
                return true;
            }
            predecessor = ShallowEntityTraversalUtils.getPreviousEntity((ShallowEntity)predecessor);
        }
        return false;
    }

    private static TokenPattern staticAssignment(TokenPattern qualifierPattern) {
        return new TokenPattern().sequence(new Object[]{qualifierPattern, ETokenType.EQ, STATIC_IV_PATTERN});
    }

    private static TokenPattern dynamicAssignment(TokenPattern iv) {
        return new TokenPattern().alternative(new Object[]{new TokenPattern().sequence(new Object[]{iv, ETokenType.EQ}), new TokenPattern().sequence(new Object[]{ETokenType.DOT, NEXT_BYTES_MATCHER, ETokenType.LPAREN, iv}), new TokenPattern().sequence(new Object[]{ETokenType.DOT, GET_MATCHER, ETokenType.LPAREN}).skipUntil(new Object[]{iv})});
    }

    private static TokenPattern buildQualifierPattern(List<IToken> tokens) {
        if (tokens.isEmpty()) {
            return TokenPattern.NEVER_MATCHING_PATTERN;
        }
        TokenPattern pattern = new TokenPattern();
        for (IToken token : tokens) {
            if (token.getType() == ETokenType.IDENTIFIER) {
                pattern.sequence(new Object[]{ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{token.getText()})})});
                continue;
            }
            if (token.getType() != ETokenType.DOT) continue;
            pattern.sequence(new Object[]{ETokenType.DOT});
        }
        return pattern;
    }

    private void createFinding(ShallowEntity constructor) {
        this.buildFinding("Use a dynamically-generated, random IV", this.buildLocation().forEntity(constructor)).createAndStore();
    }
}

