/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.java.CollectClassesPhase;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;

@Check(id="cqse-identical-class-names", languages={ELanguage.JAVA, ELanguage.KOTLIN, ELanguage.GROOVY}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE}, phases={CollectClassesPhase.class})
public class IdenticalClassNamesCheck
extends CheckImplementationBase {
    public static final String FINDING_MESSAGE = "Identical class name `%s` defined in %d locations";
    @CheckOption(name="Identical class names: include nested classes", description="Consider nested classes with identical names in addition to top level classes.")
    private boolean considerNestedClasses = false;

    private List<CollectClassesPhase.ClassInfo> getClassInfos() {
        List classInfos = (List)this.context.accessPhaseResult(CollectClassesPhase.class).apply(this.context.getUniformPath());
        if (!this.considerNestedClasses) {
            return classInfos.stream().filter(info -> !info.getAdditionalInformation().isNested()).toList();
        }
        return classInfos;
    }

    public void execute() throws CheckException {
        List<CollectClassesPhase.ClassInfo> classInfos = this.getClassInfos();
        Function getInfoForClass = this.context.accessPhaseInvertedResult(CollectClassesPhase.class);
        for (CollectClassesPhase.ClassInfo currentClass : classInfos) {
            List<CollectClassesPhase.ClassInfo> otherClasses = this.getOtherClasses(getInfoForClass, currentClass);
            if (otherClasses.isEmpty()) continue;
            List<TextRegionLocation> siblingLocations = otherClasses.stream().map(otherClass -> otherClass.getAdditionalInformation().location()).toList();
            this.buildFinding(FINDING_MESSAGE.formatted(currentClass.getValue(), siblingLocations.size() + 1), (ElementLocation)currentClass.getAdditionalInformation().location()).addSiblingLocations(siblingLocations).createAndStore();
        }
    }

    private List<CollectClassesPhase.ClassInfo> getOtherClasses(Function<String, List<CollectClassesPhase.ClassInfo>> getInfoForClass, CollectClassesPhase.ClassInfo currentClass) {
        Stream<CollectClassesPhase.ClassInfo> otherClasses = getInfoForClass.apply(currentClass.getValue()).stream().filter(cls -> !currentClass.getAdditionalInformation().packageName().equals(cls.getAdditionalInformation().packageName()));
        if (!this.considerNestedClasses) {
            otherClasses = otherClasses.filter(cls -> !cls.getAdditionalInformation().isNested());
        }
        return otherClasses.toList();
    }
}

