/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.java.DisabledJunitCheckUtils;
import java.util.List;

@Check(id="cqse-ignored-junit-test", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class IgnoredJUnitTestCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List<DisabledJunitCheckUtils.DisabledJUnitCheck> disabledJunitTests = DisabledJunitCheckUtils.findDisabledJunitTests(this.context.getAbstractSyntaxTree(this.getCodeViewOption()));
        for (DisabledJunitCheckUtils.DisabledJUnitCheck disabledJunitTest : disabledJunitTests) {
            if (disabledJunitTest.rationale() == null) {
                this.buildFinding("Avoid disabled JUnit tests", this.buildLocation().forEntityFirstLine(disabledJunitTest.entity())).createAndStore();
                continue;
            }
            this.buildFinding("Avoid disabled JUnit tests (Disable message is: `" + disabledJunitTest.rationale() + "`)", this.buildLocation().forEntityFirstLine(disabledJunitTest.entity())).createAndStore();
        }
    }
}

