/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.ECheckTarget;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.JavaMethodCallMatcher;
import eu.cqse.check.java.DisabledJunitCheckUtils;
import java.util.List;
import java.util.Set;

@Check(id="java:S1607", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE}, target={ECheckTarget.TEST_CODE})
public class IgnoredTestsCheckWithoutRationaleCheck
extends CheckImplementationBase {
    private static final JavaMethodCallMatcher NON_CONFORMING_JUNIT_ASSUME_CALLS = JavaMethodCallMatcher.create().onTypes(new String[]{"org.junit.Assume"}).withTargetMethodNames(new String[]{"assumeTrue", "assumeFalse"}).withParameterCount(1);

    public void execute() throws CheckException {
        if (!this.context.isTestCode()) {
            return;
        }
        this.flagDisabledTests();
        this.flagConstantAssertions();
    }

    private void flagDisabledTests() throws CheckException {
        List<DisabledJunitCheckUtils.DisabledJUnitCheck> disabledJunitTests = DisabledJunitCheckUtils.findDisabledJunitTests(this.context.getAbstractSyntaxTree(this.getCodeViewOption()));
        for (DisabledJunitCheckUtils.DisabledJUnitCheck disabledJunitTest : disabledJunitTests) {
            if (disabledJunitTest.rationale() != null) continue;
            this.buildFinding("Either add an explanation about why this test is skipped or remove the `@" + disabledJunitTest.annotation() + "` annotation", this.buildLocation().forEntityFirstLine(disabledJunitTest.entity())).createAndStore();
        }
    }

    private void flagConstantAssertions() throws CheckException {
        JavaImportSensitiveTypeResolver typeResolver = new JavaImportSensitiveTypeResolver(this.context.getRootEntity(this.getCodeViewOption()));
        for (JavaMethodCallMatcher.MethodCall assumeCall : NON_CONFORMING_JUNIT_ASSUME_CALLS.find(this.context, typeResolver)) {
            if (assumeCall.entity().getParent() == null || assumeCall.entity().getParent().getType() != EShallowEntityType.METHOD) continue;
            String parameterValue = TokenStreamTextUtils.concatTokenTexts((List)((List)assumeCall.parameters().getFirst()));
            String calledMethod = assumeCall.token().getText();
            if ((!calledMethod.equals("assumeTrue") || !Set.of("false", "Boolean.FALSE").contains(parameterValue)) && (!calledMethod.equals("assumeFalse") || !Set.of("true", "Boolean.TRUE").contains(parameterValue))) continue;
            this.buildFinding("This assumption is called with a boolean constant; remove it or, to skip this test use an `@Ignore`/`@Disabled` annotation in combination with an explanation about why it is skipped", this.buildLocation().forToken((IToken)((List)assumeCall.parameters().getFirst()).getFirst())).createAndStore();
        }
    }
}

