/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import eu.cqse.check.framework.util.tokens.TokenStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-java-avoid-var-keyword", languages={ELanguage.JAVA})
public class JavaAvoidVarKeywordCheck
extends CheckImplementationBase {
    @CheckOption(name="Allow var keyword when a literal value is assigned", description="Allow the usage of `var` when the right-hand side of an assignment is a literal value.")
    private boolean allowVarWhenALiteralValueIsAssigned = false;
    @CheckOption(name="Allow var keyword when an object is allocated", description="Allow the usage of `var` when the right-hand side of an assignment is an object allocation, e.g., `var list = new ArrayList<String>();`.")
    private boolean allowVarWhenAnObjectAllocated = false;
    private static final String FINDINGS_MESSAGE = "The `var` keyword should not be used";
    private static final TokenPattern VAR_ASSIGNMENT_LEFT_SIDE_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.VAR, ETokenType.IDENTIFIER, ETokenType.EQ.or(new ITokenMatcher[]{ETokenType.COLON})}).group(0);
    private static final TokenPattern SIMPLE_LITERAL_PATTERN = new TokenPattern().optional(new Object[]{ETokenType.MINUS}).sequence(new Object[]{ETokenType.ETokenClass.LITERAL});
    private static final TokenPattern COMPOSITE_LITERAL_PATTERN = new TokenPattern().alternative(new Object[]{new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER, ETokenType.DOT, ETokenType.CLASS_LITERAL}), new TokenPattern().sequence(new Object[]{ETokenType.LPAREN, ETokenType.BYTE, ETokenType.RPAREN, ETokenType.INTEGER_LITERAL}), new TokenPattern().sequence(new Object[]{ETokenType.LPAREN, ETokenType.SHORT, ETokenType.RPAREN, ETokenType.INTEGER_LITERAL})});
    private static final TokenPattern LITERAL_PATTERN = new TokenPattern().alternative(new Object[]{SIMPLE_LITERAL_PATTERN, COMPOSITE_LITERAL_PATTERN});

    public void execute() throws CheckException {
        UnmodifiableList tokens = this.context.getTokens(this.getCodeViewOption());
        List varIndices = TokenStreamUtils.findAll((List)tokens, (ITokenMatcher)ETokenType.VAR);
        if (!this.allowVarWhenALiteralValueIsAssigned && !this.allowVarWhenAnObjectAllocated) {
            varIndices.forEach(arg_0 -> this.lambda$execute$0((List)tokens, arg_0));
            return;
        }
        this.processVarAssignmentsWithFiltering(varIndices, (List<IToken>)tokens);
    }

    private void processVarAssignmentsWithFiltering(List<Integer> varIndices, List<IToken> tokens) {
        Map<IToken, List<IToken>> varAssignments = JavaAvoidVarKeywordCheck.extractAssignmentRightSides(varIndices, tokens);
        if (this.allowVarWhenALiteralValueIsAssigned) {
            varAssignments.entrySet().removeIf(JavaAvoidVarKeywordCheck::isLiteralAssignment);
        }
        if (this.allowVarWhenAnObjectAllocated) {
            varAssignments.entrySet().removeIf(JavaAvoidVarKeywordCheck::isAllocationAssignment);
        }
        varAssignments.keySet().forEach(varToken -> this.buildFinding(FINDINGS_MESSAGE, this.buildLocation().forToken(varToken)).createAndStore());
    }

    private static Map<IToken, List<IToken>> extractAssignmentRightSides(List<Integer> varIndices, List<IToken> tokens) {
        HashMap<IToken, List<IToken>> varAssignments = HashMap.newHashMap(varIndices.size());
        TokenStream tokenStream = new TokenStream(tokens, 0);
        for (int varIndex : varIndices) {
            tokenStream.setPosition(varIndex);
            TokenPatternMatch leftSideMatch = VAR_ASSIGNMENT_LEFT_SIDE_PATTERN.matchAtCurrentPosition(tokenStream);
            if (leftSideMatch == null) continue;
            int rightSideStartIndex = varIndex + 3;
            int rightSideEndIndex = TokenStreamUtils.findFirstTopLevel(tokens, (int)rightSideStartIndex, (ITokenMatcher)ETokenType.SEMICOLON.or(new ITokenMatcher[]{ETokenType.RPAREN}), (List)TokenStreamUtils.STANDARD_OPENING_TOKEN_TYPES, (List)TokenStreamUtils.STANDARD_CLOSING_TOKEN_TYPES);
            if (rightSideEndIndex == -1) continue;
            List<IToken> rightSideTokens = tokens.subList(rightSideStartIndex, rightSideEndIndex);
            varAssignments.put(tokens.get(varIndex), rightSideTokens);
        }
        return varAssignments;
    }

    private static boolean isLiteralAssignment(Map.Entry<IToken, List<IToken>> entry) {
        List<IToken> rightSideTokens = entry.getValue();
        TokenPatternMatch tokenPatternMatch = LITERAL_PATTERN.matchFully(rightSideTokens);
        return tokenPatternMatch != null;
    }

    private static boolean isAllocationAssignment(Map.Entry<IToken, List<IToken>> entry) {
        List<IToken> rightSideTokens = entry.getValue();
        if (!TokenStreamUtils.startsWith(rightSideTokens, (ETokenType[])new ETokenType[]{ETokenType.NEW})) {
            return false;
        }
        int dotIndex = TokenStreamUtils.findFirstTopLevel(rightSideTokens, (int)0, (ITokenMatcher)ETokenType.DOT, (List)TokenStreamUtils.STANDARD_OPENING_TOKEN_TYPES, (List)TokenStreamUtils.STANDARD_CLOSING_TOKEN_TYPES);
        return dotIndex == -1;
    }

    private /* synthetic */ void lambda$execute$0(List tokens, Integer varIndex) {
        this.buildFinding(FINDINGS_MESSAGE, this.buildLocation().forToken((IToken)tokens.get(varIndex))).createAndStore();
    }
}

