/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-java-usage-of-assert-keyword", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class JavaDoNotUseAssertKeywordCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        String message = "The `assert` keyword should not be used";
        List syntaxTree = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)syntaxTree, (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            for (IToken assertToken : TokenStreamUtils.findAllTokens((List)statement.ownStartTokens(), (ITokenMatcher)ETokenType.ASSERT)) {
                this.buildFinding("The `assert` keyword should not be used", this.buildLocation().forToken(assertToken)).createAndStore();
            }
        }
    }
}

