/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.ECheckTarget;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.EJavaTestFramework;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="java:S5826", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE}, target={ECheckTarget.TEST_CODE})
public class JunitAnnotationConsistencyCheck
extends CheckImplementationBase {
    private static final Set<String> JUNIT_SETUP_METHODS = CollectionUtils.asHashSet((Object[])new String[]{"setUp", "before"});
    private static final Set<String> JUNIT_TEARDOWN_METHODS = CollectionUtils.asHashSet((Object[])new String[]{"tearDown", "after"});
    private static final String JUNIT5_BEFORE_ALL_ANNOTATION = "org.junit.jupiter.api.BeforeAll";
    private static final String JUNIT5_AFTER_ALL_ANNOTATION = "org.junit.jupiter.api.AfterAll";
    private static final String JUNIT5_BEFORE_EACH_ANNOTATION = "org.junit.jupiter.api.BeforeEach";
    private static final String JUNIT5_AFTER_EACH_ANNOTATION = "org.junit.jupiter.api.AfterEach";
    private static final String JUNIT4_BEFORE_CLASS_ANNOTATION = "org.junit.BeforeClass";
    private static final String JUNIT4_AFTER_CLASS_ANNOTATION = "org.junit.AfterClass";
    private static final String JUNIT4_BEFORE_ANNOTATION = "org.junit.Before";
    private static final String JUNIT4_AFTER_ANNOTATION = "org.junit.After";
    private static final Set<String> JUNIT5_ANNOTATIONS = Set.of("org.junit.jupiter.api.BeforeAll", "org.junit.jupiter.api.BeforeEach", "org.junit.jupiter.api.AfterAll", "org.junit.jupiter.api.AfterEach", "org.junit.jupiter.api.Test");
    private static final Set<String> JUNIT4_ANNOTATIONS = Set.of("org.junit.BeforeClass", "org.junit.Before", "org.junit.AfterClass", "org.junit.After", "org.junit.Test");
    private static final Map<AnnotationLookupKey, AnnotationInfo> ANNOTATION_LOOKUP = Map.ofEntries(JunitAnnotationConsistencyCheck.createEntry(true, true, true, "org.junit.jupiter.api.BeforeAll", "org.junit.BeforeClass", "org.junit.jupiter.api.BeforeAll"), JunitAnnotationConsistencyCheck.createEntry(true, true, false, "org.junit.jupiter.api.BeforeEach", "org.junit.Before", "org.junit.jupiter.api.BeforeAll", "org.junit.jupiter.api.BeforeEach"), JunitAnnotationConsistencyCheck.createEntry(true, false, true, "org.junit.BeforeClass", "org.junit.jupiter.api.BeforeAll", "org.junit.BeforeClass"), JunitAnnotationConsistencyCheck.createEntry(true, false, false, "org.junit.Before", "org.junit.jupiter.api.BeforeEach", "org.junit.Before"), JunitAnnotationConsistencyCheck.createEntry(false, true, true, "org.junit.jupiter.api.AfterAll", "org.junit.AfterClass", "org.junit.jupiter.api.AfterAll"), JunitAnnotationConsistencyCheck.createEntry(false, true, false, "org.junit.jupiter.api.AfterEach", "org.junit.After", "org.junit.jupiter.api.AfterAll", "org.junit.jupiter.api.AfterEach"), JunitAnnotationConsistencyCheck.createEntry(false, false, true, "org.junit.AfterClass", "org.junit.jupiter.api.AfterAll", "org.junit.AfterClass"), JunitAnnotationConsistencyCheck.createEntry(false, false, false, "org.junit.After", "org.junit.jupiter.api.AfterEach", "org.junit.After"));

    private static Map.Entry<AnnotationLookupKey, AnnotationInfo> createEntry(boolean isSetup, boolean isJunit5, boolean isStatic, String expectedAnnotation, String wrongVersionAnnotation, String ... possibleAnnotations) {
        return new AbstractMap.SimpleEntry<AnnotationLookupKey, AnnotationInfo>(new AnnotationLookupKey(isSetup, isJunit5, isStatic), new AnnotationInfo(expectedAnnotation, wrongVersionAnnotation, Set.of(possibleAnnotations)));
    }

    public void execute() throws CheckException {
        State state = this.buildState();
        List typeEntities = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getRootEntity(this.getCodeViewOption()).getChildren(), (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity typeEntity : typeEntities) {
            this.processType(typeEntity, state);
        }
    }

    private State buildState() throws CheckException {
        List<String> junitImports = LanguageFeatureParser.JAVA.getImportStatements((List)this.getRootChildren()).stream().map(ShallowEntity::getName).filter(Objects::nonNull).filter(importedNamespace -> importedNamespace.startsWith("org.junit.")).toList();
        HashSet<String> junit4Imports = new HashSet<String>();
        HashSet<String> junit5Imports = new HashSet<String>();
        junitImports.forEach(jUnitImport -> {
            if (jUnitImport.startsWith(EJavaTestFramework.JUNIT_5.getNamespacePrefix())) {
                junit5Imports.add((String)jUnitImport);
            } else {
                junit4Imports.add((String)jUnitImport);
            }
        });
        return new State(junit5Imports, junit4Imports);
    }

    private void processType(ShallowEntity typeEntity, State state) {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType(List.of(typeEntity), (EShallowEntityType)EShallowEntityType.METHOD);
        OptionalInt jUnitVersion = JunitAnnotationConsistencyCheck.getJUnitVersion(methods, state);
        if (jUnitVersion.isEmpty()) {
            return;
        }
        if (TokenStreamTextUtils.concatTokenTexts((List)typeEntity.ownStartTokens(), (String)" ").contains("extends junit . framework . TestCase")) {
            return;
        }
        List<ShallowEntity> tearDownAndSetupMethods = methods.stream().filter(JunitAnnotationConsistencyCheck::isJunitSetupOrTeardown).toList();
        this.processSetupOrTeardownMethods(jUnitVersion.getAsInt(), tearDownAndSetupMethods);
    }

    private void processSetupOrTeardownMethods(int jUnitVersion, List<ShallowEntity> tearDownAndSetupMethods) {
        for (ShallowEntity tearDownOrSetupMethod : tearDownAndSetupMethods) {
            AnnotationLookupKey key = JunitAnnotationConsistencyCheck.createLookupKey(tearDownOrSetupMethod, jUnitVersion);
            AnnotationInfo info = ANNOTATION_LOOKUP.get(key);
            this.checkMethodAnnotations(tearDownOrSetupMethod, info.possibleAnnotations(), info.expectedAnnotation(), info.wrongVersionAnnotation(), jUnitVersion);
        }
    }

    private static AnnotationLookupKey createLookupKey(ShallowEntity method, int jUnitVersion) {
        boolean isSetup = JUNIT_SETUP_METHODS.contains(method.getName());
        boolean isJunit5 = jUnitVersion == 5;
        boolean isStatic = LanguageFeatureParser.JAVA.isStatic(method);
        return new AnnotationLookupKey(isSetup, isJunit5, isStatic);
    }

    private static boolean isJunitSetupOrTeardown(ShallowEntity method) {
        return (JUNIT_SETUP_METHODS.contains(method.getName()) || JUNIT_TEARDOWN_METHODS.contains(method.getName())) && LanguageFeatureParser.JAVA.getMethodArguments(method).isEmpty() && !LanguageFeatureParser.JAVA.hasExplicitVisibility(method, ETokenType.PRIVATE) && !LanguageFeatureParser.JAVA.hasAnnotation(method, new String[]{"Override"});
    }

    private void checkMethodAnnotations(ShallowEntity method, Set<String> requiredAnnotation, String expectedAnnotation, String wrongJunitVersionAnnotation, int targetJunitVersion) {
        if (LanguageFeatureParser.JAVA.hasAnnotation(method, JunitAnnotationConsistencyCheck.getSimpleAndFullQualifiedNames(requiredAnnotation))) {
            return;
        }
        Optional wrongVersionAnnotation = LanguageFeatureParser.JAVA.getFirstMatchingAnnotation(method, (Set)CollectionUtils.asHashSet((Object[])new String[]{wrongJunitVersionAnnotation, JunitAnnotationConsistencyCheck.removePackage(wrongJunitVersionAnnotation)}));
        String findingMessageBase = "Annotate this method with JUnit" + targetJunitVersion + " `@" + expectedAnnotation + "`";
        String findingMessage = findingMessageBase + " or rename it to avoid confusion";
        if (wrongVersionAnnotation.isPresent()) {
            String wrongVersionJUnit = targetJunitVersion == 5 ? "JUnit4" : "JUnit5";
            findingMessage = findingMessageBase + " instead of " + wrongVersionJUnit + " `@" + JunitAnnotationConsistencyCheck.removePackage((String)wrongVersionAnnotation.get()) + "`";
        }
        this.buildFinding(findingMessage, this.buildLocation().forEntityFirstLine(method)).createAndStore();
    }

    private static Set<String> getSimpleAndFullQualifiedNames(Set<String> fullyQualifiedAnnotations) {
        HashSet<String> result = new HashSet<String>(fullyQualifiedAnnotations);
        result.addAll(fullyQualifiedAnnotations.stream().map(JunitAnnotationConsistencyCheck::removePackage).collect(Collectors.toSet()));
        return result;
    }

    private static String removePackage(String fullyQualifiedAnnotation) {
        return StringUtils.getLastPart((String)fullyQualifiedAnnotation, (char)'.');
    }

    private static OptionalInt getJUnitVersion(List<ShallowEntity> methods, State state) {
        if (!state.junit5Imports().isEmpty()) {
            return OptionalInt.of(5);
        }
        OptionalInt jUnitVersion = OptionalInt.empty();
        for (ShallowEntity method : methods) {
            if (JunitAnnotationConsistencyCheck.hasAnnotation(method, JUNIT5_ANNOTATIONS, state.junit5Imports())) {
                return OptionalInt.of(5);
            }
            if (!JunitAnnotationConsistencyCheck.hasAnnotation(method, JUNIT4_ANNOTATIONS, state.junit4Imports())) continue;
            jUnitVersion = OptionalInt.of(4);
        }
        return jUnitVersion;
    }

    private static boolean hasAnnotation(ShallowEntity method, Set<String> annotations, Set<String> importsOfFile) {
        return LanguageFeatureParser.JAVA.hasAnnotation(method, annotations) || annotations.stream().anyMatch(fullQualifiedAnnotation -> importsOfFile.contains(fullQualifiedAnnotation) || importsOfFile.contains(StringUtils.removeLastPart((String)fullQualifiedAnnotation, (char)'.') + "*"));
    }

    private record AnnotationLookupKey(boolean isSetup, boolean isJunit5, boolean isStatic) {
    }

    private record AnnotationInfo(String expectedAnnotation, String wrongVersionAnnotation, Set<String> possibleAnnotations) {
    }

    private record State(Set<String> junit5Imports, Set<String> junit4Imports) {
    }
}

