/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.shallowparser.util.EntitySelectionPredicates;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@Check(id="cqse-method-always-returns-same-value", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class MethodAlwaysReturnsSameValueCheck
extends CheckImplementationBase {
    private static final String METHOD_FINDINGS_MESSAGE = "Method always returns the same value ({0})";
    @CheckOption(name="Include enum valued returns", description="When enabled this includes methods that always return the same enum value in addition to constant literals in the findings.")
    boolean includeEnumValues = true;

    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            this.processEntity(method);
        }
    }

    private void processEntity(ShallowEntity methodEntity) throws CheckException {
        if (MethodAlwaysReturnsSameValueCheck.shouldBeIgnored(methodEntity)) {
            return;
        }
        String returnValueText = this.getMethodReturnValueIfConstant(methodEntity);
        if (!returnValueText.isEmpty()) {
            this.buildFinding(MessageFormat.format(METHOD_FINDINGS_MESSAGE, MethodAlwaysReturnsSameValueCheck.shortenIfNeeded(returnValueText)), this.buildLocation().forEntity(methodEntity)).createAndStore();
        }
    }

    private static String shortenIfNeeded(String message) {
        if (message.length() >= 100) {
            return message.substring(0, 100) + "[...]";
        }
        return message;
    }

    private String getMethodReturnValueIfConstant(ShallowEntity methodEntity) {
        String returnValueText = "";
        for (ShallowEntity statement : ShallowEntityTraversalUtils.listEntitiesOfType(Collections.singleton(methodEntity), (EShallowEntityType)EShallowEntityType.STATEMENT)) {
            Object tokens = statement.ownStartTokens();
            if (tokens.isEmpty() || ((IToken)tokens.get(0)).getType() != ETokenType.RETURN) continue;
            if (tokens.size() == 1 || ((IToken)tokens.get(tokens.size() - 1)).getType() == ETokenType.LPAREN) {
                return "";
            }
            if (!(MethodAlwaysReturnsSameValueCheck.isLiteralReturn((List<IToken>)(tokens = tokens.subList(1, tokens.size() - 1))) || this.includeEnumValues && this.isEnumReturn(methodEntity, (List<IToken>)tokens))) {
                return "";
            }
            if (returnValueText.isEmpty()) {
                returnValueText = TokenStreamTextUtils.concatTokenTexts((List)tokens);
                continue;
            }
            if (returnValueText.equals(TokenStreamTextUtils.concatTokenTexts((List)tokens))) continue;
            return "";
        }
        return returnValueText;
    }

    private static boolean shouldBeIgnored(ShallowEntity methodEntity) {
        Optional parentClass;
        if ("constructor".equals(methodEntity.getSubtype()) || EntitySelectionPredicates.annotated((String)"Override").test(methodEntity) || ((IToken)methodEntity.ownStartTokens().get(0)).getType() == ETokenType.PROTECTED || TokenStreamUtils.containsSequence((List)methodEntity.ownStartTokens(), (ITokenMatcher[])new ITokenMatcher[]{ETokenType.VOID, ETokenType.IDENTIFIER})) {
            return true;
        }
        if (EntitySelectionPredicates.annotated((String)"@SuppressWarnings").test(methodEntity)) {
            List annotations = LanguageFeatureParser.JAVA.getAnnotations(methodEntity);
            for (ShallowEntity annotation : annotations) {
                if (!"SuppressWarnings".equals(annotation.getName()) || !TokenStreamTextUtils.contains((List)annotation.ownStartTokens(), (String)"\"override\"") && !TokenStreamTextUtils.contains((List)annotation.ownStartTokens(), (String)"\"Override\"")) continue;
                return true;
            }
        }
        if ((parentClass = ShallowEntityTraversalUtils.findParentEntity((ShallowEntity)methodEntity, entity -> entity.getType() == EShallowEntityType.TYPE)).isEmpty()) {
            return false;
        }
        return "interface".equals(((ShallowEntity)parentClass.get()).getSubtype()) || "class".equals(((ShallowEntity)parentClass.get()).getSubtype()) && TokenStreamUtils.contains((List)((ShallowEntity)parentClass.get()).ownStartTokens(), (ETokenType)ETokenType.ABSTRACT);
    }

    private static boolean isLiteralReturn(List<IToken> returnValue) {
        return returnValue.stream().map(IToken::getType).allMatch(type -> type.isLiteral() || type.isOperator());
    }

    private boolean isEnumReturn(ShallowEntity methodEntity, List<IToken> returnValue) {
        boolean expectIdentifier = true;
        for (int i = 0; i < returnValue.size(); ++i) {
            IToken token = returnValue.get(i);
            if (expectIdentifier && token.getType().isIdentifier()) {
                expectIdentifier = false;
                continue;
            }
            if (!expectIdentifier && token.getType() == ETokenType.DOT && i != returnValue.size() - 1) {
                expectIdentifier = true;
                continue;
            }
            return false;
        }
        String methodReturnType = LanguageFeatureParser.JAVA.getReturnType(methodEntity);
        if (methodReturnType == null) {
            return false;
        }
        if (returnValue.size() >= 3) {
            String returnType = TokenStreamTextUtils.concatTokenTexts(returnValue.subList(0, returnValue.size() - 2));
            return methodReturnType.equals(returnType);
        }
        return this.isImportedEnumType(methodReturnType, returnValue);
    }

    private boolean isImportedEnumType(String methodReturnType, List<IToken> returnValue) {
        List importEntities;
        if (returnValue.size() != 1 || methodReturnType == null) {
            return false;
        }
        try {
            importEntities = CheckImplementationBase.select((ShallowEntity)this.context.getRootEntity(this.getCodeViewOption()), (String)"/META[subtype('static import')]");
        }
        catch (CheckException e) {
            return false;
        }
        String[] returnType = methodReturnType.split("\\.");
        for (ShallowEntity entity : importEntities) {
            String[] importType = TokenStreamTextUtils.concatTokenTexts((List)entity.ownStartTokens().subList(2, entity.ownStartTokens().size() - 1)).split("\\.");
            if (importType.length < 2 || !importType[importType.length - 1].equals(returnValue.get(0).getText()) || importType.length < returnType.length) continue;
            int importIndex = importType.length - 2;
            for (int returnIndex = returnType.length - 1; importIndex >= 0 && returnIndex >= 0 && importType[importIndex].equals(returnType[returnIndex]); --importIndex, --returnIndex) {
                if (returnIndex != 0) continue;
                return true;
            }
        }
        return false;
    }
}

