/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.JavaMethodCallMatcher;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="java:S6863", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class StatusCodesOnResponseCheck
extends CheckImplementationBase {
    private static final Set<String> OK_CODES = Set.of("ACCEPTED", "ALREADY_REPORTED", "CHECKPOINT", "CONTINUE", "CREATED", "FOUND", "IM_USED", "MOVED_PERMANENTLY", "MULTIPLE_CHOICES", "MULTI_STATUS", "NON_AUTHORITATIVE_INFORMATION", "NOT_MODIFIED", "NO_CONTENT", "OK", "PARTIAL_CONTENT", "PERMANENT_REDIRECT", "PROCESSING", "RESET_CONTENT", "SEE_OTHER", "SWITCHING_PROTOCOLS", "TEMPORARY_REDIRECT");
    private static final Set<String> ERROR_CODES = Set.of("BAD_GATEWAY", "BAD_REQUEST", "BANDWIDTH_LIMIT_EXCEEDED", "CONFLICT", "EXPECTATION_FAILED", "FAILED_DEPENDENCY", "FORBIDDEN", "GATEWAY_TIMEOUT", "GONE", "HTTP_VERSION_NOT_SUPPORTED", "INSUFFICIENT_STORAGE", "INTERNAL_SERVER_ERROR", "I_AM_A_TEAPOT", "LENGTH_REQUIRED", "LOCKED", "LOOP_DETECTED", "METHOD_NOT_ALLOWED", "NETWORK_AUTHENTICATION_REQUIRED", "NOT_ACCEPTABLE", "NOT_EXTENDED", "NOT_FOUND", "NOT_IMPLEMENTED", "PAYLOAD_TOO_LARGE", "PAYMENT_REQUIRED", "PRECONDITION_FAILED", "PRECONDITION_REQUIRED", "PROXY_AUTHENTICATION_REQUIRED", "REQUESTED_RANGE_NOT_SATISFIABLE", "REQUEST_HEADER_FIELDS_TOO_LARGE", "REQUEST_TIMEOUT", "SERVICE_UNAVAILABLE", "TOO_MANY_REQUESTS", "UNAUTHORIZED", "UNAVAILABLE_FOR_LEGAL_REASONS", "UNPROCESSABLE_ENTITY", "UNSUPPORTED_MEDIA_TYPE", "UPGRADE_REQUIRED", "URI_TOO_LONG", "VARIANT_ALSO_NEGOTIATES");
    private JavaImportSensitiveTypeResolver typeResolver;

    public void execute() throws CheckException {
        this.typeResolver = new JavaImportSensitiveTypeResolver(this.context.getRootEntity(this.getCodeViewOption()));
        for (ShallowEntity classEntity : ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE)) {
            if (!LanguageFeatureParser.JAVA.getAnnotations(classEntity).stream().anyMatch(annotation -> LanguageFeatureParser.JAVA.isSpecificAnnotation(annotation, Set.of("org.springframework.stereotype.Controller", "Controller", "org.springframework.web.bind.annotation.RestController", "RestController")))) continue;
            this.handleClass();
        }
    }

    private void handleClass() throws CheckException {
        List okMatches = JavaMethodCallMatcher.create().onTypes(new String[]{"org.springframework.http.ResponseEntity"}).withTargetMethodNames(new String[]{"ok", "created", "accepted", "noContent"}).withParameterCount(0).find(this.context, this.typeResolver);
        for (Object okMatch : okMatches) {
            this.handle(okMatch.entity(), StringUtils.camelCaseToUnderscored((String)okMatch.methodName()));
        }
        List errorMatches = JavaMethodCallMatcher.create().onTypes(new String[]{"org.springframework.http.ResponseEntity"}).withTargetMethodNames(new String[]{"badRequest", "notFound", "unprocessableEntity"}).withParameterCount(0).find(this.context, this.typeResolver);
        for (JavaMethodCallMatcher.MethodCall errorMatch : errorMatches) {
            this.handle(errorMatch.entity(), StringUtils.camelCaseToUnderscored((String)errorMatch.methodName()));
        }
        List statusMatches = JavaMethodCallMatcher.create().onTypes(new String[]{"org.springframework.http.ResponseEntity"}).withTargetMethodNames(new String[]{"status"}).withParameterCount(1).find(this.context, this.typeResolver);
        for (JavaMethodCallMatcher.MethodCall statusMatch : statusMatches) {
            this.handle(statusMatch.entity(), ((IToken)((List)statusMatch.parameters().getFirst()).getLast()).getText());
        }
    }

    private void handle(ShallowEntity statement, String status) {
        this.handleTry(statement, status);
        this.handleCatch(statement, status);
    }

    private void handleTry(ShallowEntity statement, String status) {
        Optional tryEntity = ShallowEntityTraversalUtils.findParentEntityAndCountDepth((ShallowEntity)statement, p -> "try".equals(p.getSubtype()));
        if (tryEntity.isEmpty()) {
            return;
        }
        Pair tryPair = (Pair)tryEntity.get();
        Optional ifEntity = ShallowEntityTraversalUtils.findParentEntityAndCountDepth((ShallowEntity)statement, p -> "if".equals(p.getSubtype()));
        if (ifEntity.stream().anyMatch(ifPair -> (Integer)ifPair.getSecond() < (Integer)tryPair.getSecond())) {
            return;
        }
        if (ERROR_CODES.contains(status)) {
            this.buildFinding("Expected a success status code in try block outside of if block", this.buildLocation().forEntity(statement)).createAndStore();
        }
    }

    private void handleCatch(ShallowEntity statement, String status) {
        Optional catchEntity = ShallowEntityTraversalUtils.findParentEntityAndCountDepth((ShallowEntity)statement, p -> "catch".equals(p.getSubtype()));
        if (catchEntity.isEmpty()) {
            return;
        }
        if (OK_CODES.contains(status)) {
            this.buildFinding("Expected a failure status code in catch block", this.buildLocation().forEntity(statement)).createAndStore();
        }
    }
}

