/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class SuspiciousMethodDetector {
    private final String name;
    private final int parameterCount;

    public SuspiciousMethodDetector(String name, int parameterCount) {
        CCSMAssert.isNotNull((Object)name);
        CCSMAssert.isTrue((parameterCount >= 0 ? 1 : 0) != 0, (String)"method cannot have negative parameters");
        this.name = name;
        this.parameterCount = parameterCount;
    }

    public boolean isSuspicious(ShallowEntity methodEntity) {
        boolean nameMatches;
        boolean bl = nameMatches = methodEntity.getName() != null && methodEntity.getName().equalsIgnoreCase(this.name);
        if (ShallowParsingUtils.extractParameterNameTokens((ShallowEntity)methodEntity).size() == this.parameterCount) {
            return nameMatches && !methodEntity.getName().equals(this.name);
        }
        return nameMatches;
    }
}

