/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.concurrency;

import com.google.common.collect.Iterables;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.MatchGroupElement;
import eu.cqse.check.framework.util.tokens.TokenUtils;
import eu.cqse.check.java.concurrency.JavaCriticalSectionUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

@Check(id="cqse-avoid-excessive-synchronization", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AvoidExcessiveSynchronizationCheck
extends CheckImplementationBase {
    private static final String CHECK_NAME = "Avoid excessive synchronization";
    @CheckOption(name="Maximum length of a critical section", description="The number of source lines of code beyond which a critical section is considered too long.")
    private int maximumCriticalSectionSloc = 30;

    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            if ("lambda".equals(method.getSubtype())) continue;
            this.processEntity(method);
        }
    }

    private void processEntity(ShallowEntity method) {
        Iterable criticalSections = Iterables.concat(JavaCriticalSectionUtils.getSynchronizedMethodCriticalSections(method), JavaCriticalSectionUtils.getSynchronizedBlockCriticalSections(method), JavaCriticalSectionUtils.getLockUnlockCriticalSections(method));
        for (MatchGroupElement criticalSection : criticalSections) {
            this.checkCriticalSection(criticalSection.getTokens());
        }
    }

    private void checkCriticalSection(List<IToken> tokens) {
        int sloc = TokenUtils.countSloc(tokens, new HashSet());
        if (sloc <= this.maximumCriticalSectionSloc) {
            return;
        }
        this.buildFinding(CHECK_NAME, this.buildLocation().forTokens(tokens)).addFindingProperties(AvoidExcessiveSynchronizationCheck.lengthOfCriticalSection(sloc)).createAndStore();
    }

    private static FindingPropertyList lengthOfCriticalSection(int sloc) {
        return FindingPropertyList.singleton((String)"Length of critical section", (String)Integer.toString(sloc));
    }
}

