/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.spring;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.java.spring.SpringChecksUtils;
import java.util.Collection;
import java.util.List;

@Check(id="java:S6818", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AutowiredOnMultipleConstructorsCheck
extends CheckImplementationBase {
    private static final String MESSAGE = "Remove this `@Autowired` annotation";

    public void execute() throws CheckException {
        List ast = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        ShallowEntityTraversalUtils.listEntitiesOfType((Collection)ast, (EShallowEntityType)EShallowEntityType.TYPE).forEach(this::handleType);
    }

    private void handleType(ShallowEntity type) {
        boolean autowiredConstructorFound = false;
        for (ShallowEntity child : type.getChildren()) {
            if (!LanguageFeatureParser.JAVA.isConstructorOfType(type, child)) continue;
            for (ShallowEntity annotation : LanguageFeatureParser.JAVA.getAnnotations(child)) {
                if (!AutowiredOnMultipleConstructorsCheck.isRequiredAutowired(annotation)) continue;
                if (autowiredConstructorFound) {
                    this.buildFinding(MESSAGE, this.buildLocation().forEntity(annotation)).createAndStore();
                }
                if (autowiredConstructorFound) continue;
                autowiredConstructorFound = true;
            }
        }
    }

    private static boolean isRequiredAutowired(ShallowEntity annotation) {
        return LanguageFeatureParser.JAVA.isSpecificAnnotation(annotation, SpringChecksUtils.AUTOWIRE_ANNOTATIONS) && TokenStreamTextUtils.findSequence((List)annotation.ownStartTokens(), (String[])new String[]{"required", "=", "false"}) == -1;
    }
}

