/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.objc;

import eu.cqse.check.cpp.HeaderFileCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ITypeInfoExtractor;
import eu.cqse.check.framework.typetracker.TypeInfoExtractorFactory;
import eu.cqse.check.framework.typetracker.TypedVariable;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.conqat.lib.commons.collections.Pair;

@Check(id="cqse-objc-nullability-annotations", languages={ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ObjCNullabilityAnnotationsCheck
extends HeaderFileCheckBase {
    private static final String FINDING_MESSAGE = "%s should be annotated with nullability annotations";
    private static final Set<String> NONNULL_REGION_BEGIN_MARKERS = Set.of("NS_ASSUME_NONNULL_BEGIN", "#pragma clang assume_nonnull begin");
    private static final Set<String> NONNULL_REGION_END_MARKERS = Set.of("NS_ASSUME_NONNULL_END", "#pragma clang assume_nonnull end");
    private static final Set<ETokenType> NULLABILITY_ANNOTATIONS = EnumSet.of(ETokenType.NULLABLE, ETokenType.NONNULL);
    private final ITypeInfoExtractor extractor = TypeInfoExtractorFactory.getTypeInfoExtractor((ELanguage)ELanguage.OBJECTIVE_CPP, null);

    private static boolean entityInAuditedRegion(ShallowEntity entity) {
        List tokens = entity.getAllTokensOfFile();
        for (int index = entity.getStartTokenIndex() - 1; index >= 0; --index) {
            if (NONNULL_REGION_BEGIN_MARKERS.contains(((IToken)tokens.get(index)).getText())) {
                return true;
            }
            if (!NONNULL_REGION_END_MARKERS.contains(((IToken)tokens.get(index)).getText())) continue;
            return false;
        }
        return false;
    }

    @Override
    protected void executeHeaderCheck() throws CheckException {
        List selectedEntities = ShallowEntityTraversalUtils.selectEntities((Collection)this.context.getAbstractSyntaxTree(ECodeViewOption.FILTERED_PREPROCESSED), entity -> entity.getType() == EShallowEntityType.METHOD && !Objects.equals(entity.getSubtype(), "block expression") || Objects.equals(entity.getSubtype(), "property"));
        for (ShallowEntity entity2 : selectedEntities) {
            if (ObjCNullabilityAnnotationsCheck.entityInAuditedRegion(entity2)) continue;
            this.checkPropertiesAndMethodParameters(entity2);
            if (entity2.getType() != EShallowEntityType.METHOD) continue;
            this.checkMethodReturnType(entity2);
        }
    }

    private void checkPropertiesAndMethodParameters(ShallowEntity entity) {
        for (TypedVariable typedVariable : Objects.requireNonNull(this.extractor).extract(entity)) {
            if (!typedVariable.getTypeNameWithoutGenericTypeParameter().endsWith("*")) continue;
            if (!typedVariable.getModifiers().stream().map(IToken::getType).noneMatch(NULLABILITY_ANNOTATIONS::contains)) continue;
            String messageArg = (entity.getType() == EShallowEntityType.METHOD ? "Parameter `" : "Property `") + typedVariable.getVariableName() + "`";
            this.buildFinding(String.format(FINDING_MESSAGE, messageArg), this.buildLocation().forLine(entity.getStartLine())).createAndStore();
        }
    }

    private void checkMethodReturnType(ShallowEntity entity) {
        Pair returnTypeAndModifiers = LanguageFeatureParser.OBJECTIVE_CPP.getModifiersAndReturnType(entity);
        if (returnTypeAndModifiers == null) {
            return;
        }
        List returnTypeModifiers = (List)returnTypeAndModifiers.getFirst();
        String returnType = (String)returnTypeAndModifiers.getSecond();
        if (returnType != null && returnType.endsWith("*")) {
            if (returnTypeModifiers.stream().map(IToken::getType).noneMatch(NULLABILITY_ANNOTATIONS::contains)) {
                this.buildFinding(String.format(FINDING_MESSAGE, "Method `" + entity.getName() + "` return type"), this.buildLocation().forLine(entity.getStartLine())).createAndStore();
            }
        }
    }
}

