/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.plsql;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-exception-handler-others", languages={ELanguage.PLSQL}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ExceptionHandlerOthersCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            this.processEntity(method);
        }
    }

    private void processEntity(ShallowEntity method) throws CheckException {
        ShallowEntity exceptionStartChild = null;
        boolean hadWhenOthers = false;
        for (ShallowEntity child : method.getChildren()) {
            if (ExceptionHandlerOthersCheck.isExceptionStart(child)) {
                exceptionStartChild = child;
                continue;
            }
            if (exceptionStartChild == null || !ExceptionHandlerOthersCheck.isWhenOthers(child)) continue;
            hadWhenOthers = true;
        }
        if (exceptionStartChild != null && !hadWhenOthers) {
            this.buildFinding("WHEN OTHERS missing from exception handlers", this.buildLocation().forEntityFirstLine(exceptionStartChild)).createAndStore();
        }
    }

    private static boolean isExceptionStart(ShallowEntity child) {
        return child.getType() == EShallowEntityType.META && ((IToken)child.includedTokens().get(0)).getType() == ETokenType.EXCEPTION;
    }

    private static boolean isWhenOthers(ShallowEntity child) {
        UnmodifiableList tokens = child.includedTokens();
        return child.getType() == EShallowEntityType.META && tokens.size() >= 2 && ((IToken)tokens.get(0)).getType() == ETokenType.WHEN && ((IToken)tokens.get(1)).getType() == ETokenType.OTHERS;
    }
}

