/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.plsql;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-unclosed-cursor", languages={ELanguage.PLSQL}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class UnclosedCursorCheck
extends CheckImplementationBase {
    private static final ITokenMatcher OPEN_CLOSE = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.OPEN, ETokenType.CLOSE});

    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            this.processEntity(method);
        }
    }

    private void processEntity(ShallowEntity method) throws CheckException {
        UnmodifiableList tokens = method.includedTokens();
        HashMap<String, IToken> openCursors = new HashMap<String, IToken>();
        Iterator<Object> iterator = TokenStreamUtils.findAll((List)tokens, (ITokenMatcher)OPEN_CLOSE).iterator();
        block4: while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            IToken token = (IToken)tokens.get(n);
            String name = ((IToken)tokens.get(n + 1)).getText();
            switch (token.getType()) {
                case OPEN: {
                    openCursors.put(name, token);
                    continue block4;
                }
                case CLOSE: {
                    openCursors.remove(name);
                    continue block4;
                }
            }
            CCSMAssert.fail((String)"Token is neither OPEN nor CLOSE.");
        }
        for (Map.Entry entry : openCursors.entrySet()) {
            this.buildFinding("Cursor `" + (String)entry.getKey() + "` opened but not closed in the same procedure", this.buildLocation().forToken((IToken)entry.getValue())).createAndStore();
        }
    }
}

