/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.python.compatibility.python2;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-metaclasses-compatibility-python2", languages={ELanguage.PYTHON}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class MetaclassesCompatibilityPython2Check
extends CheckImplementationBase {
    public static final String FINDING_MESSAGE = "Metaclasses are used in an incompatible way";

    private static TokenPattern getFindingPattern() {
        return new TokenPattern().tokenText("metaclass").group(0).sequence(new Object[]{ETokenType.EQ});
    }

    public void execute() throws CheckException {
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            if (!"class".equals(type.getSubtype())) continue;
            this.processTokens((List<IToken>)type.ownStartTokens());
            this.processTokens((List<IToken>)type.ownEndTokens());
        }
    }

    private void processTokens(List<IToken> tokens) {
        TokenPattern pattern = MetaclassesCompatibilityPython2Check.getFindingPattern();
        for (TokenPatternMatch match : pattern.findAll(tokens)) {
            List matchedTokens = match.groupTokens(0);
            this.buildFinding(FINDING_MESSAGE, this.buildLocation().forTokens(matchedTokens)).createAndStore();
        }
    }
}

