/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.font_settings;

import eu.cqse.check.simulink.font_settings.SimulinkAndStateflowFontSettingsCheck;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.ParameterizedElement;
import org.conqat.lib.simulink.model.SimulinkAnnotation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkModel;

public class SimulinkFontChecker {
    private final SimulinkModel model;

    public SimulinkFontChecker(SimulinkModel model) {
        this.model = model;
    }

    boolean simulinkFontSettingsAreCorrect(ParameterizedElement element, SimulinkAndStateflowFontSettingsCheck.FontSettings expectedSettings) {
        if (!this.simulinkFontPropertyIsCorrect(element, expectedSettings.size, "FontSize")) {
            return false;
        }
        if (!this.simulinkFontPropertyIsCorrect(element, expectedSettings.name, "FontName")) {
            return false;
        }
        if (!this.simulinkFontPropertyIsCorrect(element, expectedSettings.angle, "FontAngle")) {
            return false;
        }
        return this.simulinkFontPropertyIsCorrect(element, expectedSettings.weight, "FontWeight");
    }

    private boolean simulinkFontPropertyIsCorrect(ParameterizedElement element, String configuredExpectedValue, String parameterName) {
        String expectedValue = configuredExpectedValue.trim().toLowerCase();
        if (parameterName.equals("FontSize")) {
            expectedValue = StringUtils.stripSuffix((String)expectedValue, (String)"pt").trim();
        }
        if ("any".equals(expectedValue)) {
            return true;
        }
        String actualValue = element.getParameter(parameterName);
        if (parameterName.equals("FontSize")) {
            actualValue = StringUtils.stripSuffix((String)actualValue, (String)"pt");
        }
        actualValue = actualValue.trim().toLowerCase();
        if ("default".equals(expectedValue)) {
            expectedValue = this.getModelDefaultParameterFor(element, parameterName);
            expectedValue = parameterName.equals("FontSize") ? StringUtils.stripSuffix((String)expectedValue.trim().toLowerCase(), (String)"pt").trim() : expectedValue.trim().toLowerCase();
        }
        return expectedValue.equals(actualValue);
    }

    private String getModelDefaultParameterFor(ParameterizedElement element, String parameterName) {
        if (element instanceof SimulinkLine) {
            return this.model.getLineDefaultParameter(parameterName);
        }
        if (element instanceof SimulinkBlock) {
            return this.model.getBlockDefaultParameter(parameterName);
        }
        if (element instanceof SimulinkAnnotation) {
            return this.model.getAnnotationDefaultParameter(parameterName);
        }
        CCSMAssert.fail((String)("Can't determine default setting for element type " + String.valueOf(element.getClass())));
        return "";
    }

    static String generateActualSettingsFindingsProperty(ParameterizedElement simulinkElement) {
        String name = SimulinkFontChecker.getParameterValueConsideringDefaults(simulinkElement, "FontName");
        String size = SimulinkFontChecker.getParameterValueConsideringDefaults(simulinkElement, "FontSize");
        String angle = SimulinkFontChecker.getParameterValueConsideringDefaults(simulinkElement, "FontAngle");
        String weight = SimulinkFontChecker.getParameterValueConsideringDefaults(simulinkElement, "FontWeight");
        return "Name: " + name + ", Size: " + size + ", Angle: " + angle + ", Weight: " + weight;
    }

    private static String getParameterValueConsideringDefaults(ParameterizedElement simulinkElement, String parameterName) {
        String name = simulinkElement.getDeclaredParameter(parameterName);
        if (name != null) {
            return name;
        }
        name = simulinkElement.getParameter(parameterName);
        return name + " (default)";
    }
}

