/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.matlab;

import eu.cqse.check.matlab.MatlabActionParserException;
import eu.cqse.check.matlab.MatlabActionTypeResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkResolvedDataTypes;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.conqat.lib.simulink.util.StateflowUtils;
import org.jspecify.annotations.NonNull;

final class SimulinkMatlabCheckUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static List<SimulinkBlock> listMatlabFunctionBlocks(SimulinkModel model) {
        ArrayList<SimulinkBlock> matlabFunctionBlocks = new ArrayList<SimulinkBlock>();
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (!StateflowUtils.isMatlabFunctionBlock((SimulinkBlock)block)) continue;
            matlabFunctionBlocks.add(block);
        }
        return matlabFunctionBlocks;
    }

    public static @NonNull List<MatlabActionTypeResolver> parseMethodsInMatlabFunctionStateAndLogParseErrors(StateflowState matlabFunctionState, SimulinkResolvedDataTypes resolvedTypes, List<SimulinkDataDictionary> dataDictionaries, String errorLocation) {
        try {
            return MatlabActionTypeResolver.fromMatlabFunctionNode((StateflowState)matlabFunctionState, (SimulinkResolvedDataTypes)resolvedTypes, dataDictionaries);
        }
        catch (MatlabActionParserException e) {
            LOGGER.warn("Could not parse code in " + errorLocation, (Throwable)e);
            return Collections.emptyList();
        }
    }

    public static @NonNull List<MatlabActionTypeResolver> parseMethodsInMatlabFunctionBlockAndLogParseErrors(SimulinkBlock block, SimulinkResolvedDataTypes resolvedTypes, List<SimulinkDataDictionary> dataDictionaries, String errorLocation) {
        try {
            return MatlabActionTypeResolver.fromMatlabFunctionBlock((SimulinkBlock)block, (SimulinkResolvedDataTypes)resolvedTypes, dataDictionaries);
        }
        catch (MatlabActionParserException e) {
            LOGGER.warn("Could not parse code in " + errorLocation, (Throwable)e);
            return Collections.emptyList();
        }
    }

    private SimulinkMatlabCheckUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

