/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.matlab;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.simulink.LocalCodeSnippetParser;
import eu.cqse.check.simulink.matlab.SimulinkMatlabCheckUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.maab.na_0022", languages={ELanguage.SIMULINK})
public class SimulinkPatternsSwitchCaseCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Consider defining a constant for the input variable.");
    private final LocalCodeSnippetParser matlabParser = new LocalCodeSnippetParser(ELanguage.MATLAB);

    public void execute() throws CheckException {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkMatlabCheckUtils.listMatlabFunctionBlocks(model)) {
            for (String script : StateflowUtils.extractMatlabScriptsFromBlock((SimulinkBlock)block)) {
                this.reportNonConstantCaseArgument(script, this.context.buildLocation().forSimulinkBlock(block));
            }
        }
        for (StateflowState stateflowMatlabFunctionState : StateflowUtils.getStateflowMatlabFunctions((SimulinkModel)model)) {
            String script = StateflowUtils.extractMatlabScriptFromStateflowState((StateflowState)stateflowMatlabFunctionState);
            this.reportNonConstantCaseArgument(script, this.context.buildLocation().forStateflowNode((StateflowNodeBase)stateflowMatlabFunctionState));
        }
    }

    private void reportNonConstantCaseArgument(String script, QualifiedNameLocation findingLocation) {
        List<ShallowEntity> entities = this.matlabParser.parseTopLevel(script, this.context.getUniformPath());
        List functions = ShallowEntityTraversalUtils.listEntitiesOfType(entities, (EShallowEntityType)EShallowEntityType.METHOD);
        ArrayList<String> cases = new ArrayList<String>();
        for (ShallowEntity function : functions) {
            Set<String> functionParameterNames = SimulinkPatternsSwitchCaseCheck.extractParameterNames(function);
            for (ShallowEntity caseEntity : ShallowEntityTraversalUtils.selectEntities(Collections.singletonList(function), entity -> entity.getSubtype().equals("case"))) {
                IToken argumentToken;
                UnmodifiableList tokens = caseEntity.includedTokens();
                if (!TokenStreamUtils.startsWith((List)tokens, (ETokenType[])new ETokenType[]{ETokenType.CASE}) || tokens.size() < 2 || (argumentToken = (IToken)tokens.get(1)).getType() != ETokenType.IDENTIFIER || !functionParameterNames.contains(argumentToken.getText())) continue;
                cases.add(argumentToken.getText());
            }
        }
        if (cases.isEmpty()) {
            return;
        }
        String caseNames = String.join((CharSequence)", ", cases);
        this.buildFinding("Function parameter is used as case argument: " + caseNames, (ElementLocation)findingLocation).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
    }

    private static Set<String> extractParameterNames(ShallowEntity function) {
        UnmodifiableList includedTokens = function.includedTokens();
        int parametersStart = TokenStreamUtils.firstTokenMatching((List)includedTokens, (ITokenMatcher)ETokenType.LPAREN);
        if (parametersStart < 0) {
            return Collections.emptySet();
        }
        int parametersEnd = TokenStreamUtils.firstTokenMatching((List)includedTokens, (int)parametersStart, (ITokenMatcher)ETokenType.RPAREN);
        UnmodifiableList parameterList = includedTokens.subList(parametersStart + 1, parametersEnd);
        List parameterListSections = TokenStreamUtils.split((List)parameterList, (ETokenType[])new ETokenType[]{ETokenType.ARRAY_SEPARATOR});
        HashSet<String> parameterNames = new HashSet<String>();
        for (List parameterListSection : parameterListSections) {
            String parameterName = TokenStreamTextUtils.concatTokenTexts((List)parameterListSection);
            parameterNames.add(parameterName);
        }
        return parameterNames;
    }
}

