/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.naming_conventions;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.simulink.ESimulinkNameCheckType;
import eu.cqse.check.simulink.SimulinkNameChecker;
import java.util.List;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.datahandler.simulink.SimulinkBlockNameUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.jmaab.jc_0231", languages={ELanguage.SIMULINK})
public class SimulinkBlockNamesCheck
extends CheckImplementationBase {
    @CheckOption(name="Disallow non-alphanumeric characters in basic block names", description="If set, basic block names that do not consist of single-byte alphanumeric characters (a-z, A-Z, 0-9) are disallowed.")
    private boolean disallowNonAlphanumericCharacters = true;
    @CheckOption(name="Disallow leading numbers in basic block names", description="If set, basic block names starting with digits are disallowed.")
    private boolean disallowStartWithNumbers = true;
    @CheckOption(name="Disallow consecutive underscores in basic block names", description="If set, basic block names with consecutive underscores (e.g. '__') are disallowed.")
    private boolean disallowConsecutiveUnderscores = true;
    @CheckOption(name="Disallow leading underscores in basic block names", description="If set, basic block names starting with underscores are disallowed.")
    private boolean disallowStartWithUnderscore = true;
    @CheckOption(name="Disallow trailing underscores in basic block names", description="If set, basic block names ending with underscores are disallowed.")
    private boolean disallowEndWithUnderscore = true;
    @CheckOption(name="Disallow basic block names as reserved MATLAB keywords", description="If set, basic block names matching reserved MATLAB keywords are disallowed.")
    private boolean disallowReservedMatlabKeyword = true;
    @CheckOption(name="Disallow basic block names as MATLAB function names", description="If set, basic block names matching MATLAB function names are disallowed.")
    private boolean disallowReservedMatlabFunctionName = false;
    @CheckOption(name="Whitelisted basic block names", description="List of all basic block names that are explicitly allowed, separated by a comma. These names are ignored by this check.")
    private String whitelistedNames = "";
    @CheckOption(name="Ignore hidden block names", description="If set, hidden block names are not checked.")
    private boolean ignoreHiddenBlockNames = false;
    private static final FindingPropertyList RECOMMENDED_ACTION_ALPHANUMERIC_CHARACTERS = FindingPropertyList.singleton((String)"Recommended Action", (String)"Remove all non-alphanumeric characters from the block name.");
    private static final FindingPropertyList RECOMMENDED_ACTION_NO_NUMBERS_AT_START = FindingPropertyList.singleton((String)"Recommended Action", (String)"Remove numbers at the start of the block name.");
    private static final FindingPropertyList RECOMMENDED_ACTION_CONSECUTIVE_UNDERSCORES = FindingPropertyList.singleton((String)"Recommended Action", (String)"Remove all consecutive underscores from the block name.");
    private static final FindingPropertyList RECOMMENDED_ACTION_NO_UNDERSCORES_AT_START_OR_END = FindingPropertyList.singleton((String)"Recommended Action", (String)"Remove all underscores at the start and end of the block name.");
    private static final FindingPropertyList RECOMMENDED_ACTION_MATLAB_FUNCTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Change the block name so that it is not  a MATLAB function name.");
    private static final FindingPropertyList RECOMMENDED_ACTION_RESERVED_KEYWORD = FindingPropertyList.singleton((String)"Recommended Action", (String)"Change the block name so that it is not a restricted MATLAB keyword.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (this.ignoreBlock(block)) continue;
            String blockName = block.getName();
            Set<ESimulinkNameCheckType> typesToCheck = SimulinkNameChecker.createTypesToCheckSetFromConfigurations(this.disallowNonAlphanumericCharacters, this.disallowStartWithNumbers, this.disallowConsecutiveUnderscores, this.disallowStartWithUnderscore, this.disallowEndWithUnderscore, this.disallowReservedMatlabKeyword, this.disallowReservedMatlabFunctionName);
            List<ESimulinkNameCheckType> failedChecks = SimulinkNameChecker.checkName(blockName, typesToCheck, this.whitelistedNames);
            for (ESimulinkNameCheckType failedCheck : failedChecks) {
                this.createFindingFromNameCheckType(block, failedCheck);
            }
        }
    }

    private void createFindingFromNameCheckType(SimulinkBlock block, ESimulinkNameCheckType failedCheckType) {
        String prettyBlockName = MarkupUtils.formatAsSourceCode((String)block.getNamePretty());
        switch (failedCheckType) {
            case ALPHANUMERIC_CHARACTER_USAGE: {
                this.buildFinding("Block " + prettyBlockName + " shall contain only letters, digits and underscores", (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_ALPHANUMERIC_CHARACTERS).createAndStore();
                break;
            }
            case NAME_STARTS_WITH_NUMBER: {
                this.buildFinding("Block " + prettyBlockName + " shall not start with a digit", (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_NO_NUMBERS_AT_START).createAndStore();
                break;
            }
            case CONSECUTIVE_UNDERSCORES_USAGE: {
                this.buildFinding("Block " + prettyBlockName + " shall not have consecutive underscores", (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_CONSECUTIVE_UNDERSCORES).createAndStore();
                break;
            }
            case NAME_STARTS_WITH_UNDERSCORE: {
                this.buildFinding("Block " + prettyBlockName + " shall not start with an underscore", (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_NO_UNDERSCORES_AT_START_OR_END).createAndStore();
                break;
            }
            case NAME_ENDS_WITH_UNDERSCORE: {
                this.buildFinding("Block " + prettyBlockName + " shall not end with an underscore", (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_NO_UNDERSCORES_AT_START_OR_END).createAndStore();
                break;
            }
            case NAME_IS_MATLAB_FUNCTION_NAME: {
                this.buildFinding("Block " + prettyBlockName + " shall not be a MATLAB function name", (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_MATLAB_FUNCTION).createAndStore();
                break;
            }
            case NAME_IS_RESERVED_MATLAB_KEYWORD: {
                this.buildFinding("Block " + prettyBlockName + " shall not be a reserved MATLAB keyword", (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_RESERVED_KEYWORD).createAndStore();
                break;
            }
        }
    }

    private boolean ignoreBlock(SimulinkBlock block) {
        return SimulinkUtils.isInport((SimulinkBlock)block) || SimulinkUtils.isOutport((SimulinkBlock)block) || block.isOfType("SubSystem") || block.isOfSourceType("SubSystem") || SimulinkBlockNameUtils.hasNameUsedByLibraryExplorer((SimulinkBlock)block) || this.ignoreHiddenBlockNames && !block.hasVisibleName() || block.getParent() == null && ("$bdroot".equals(block.getName()) || block.getName().equals(block.getModel().getName()));
    }
}

