/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.datahandler.simulink.SimulinkBlockNameUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.maab.jc_0061", languages={ELanguage.SIMULINK})
public class SimulinkBlockNamesDisplayCheck
extends CheckImplementationBase {
    private static final String FINDING_CLEAR_BLOCK_SHOWN_NAME = "The block name is shown, even though the block's type is clear from its visual appearance";
    private static final String FINDING_UNCLEAR_BLOCK_HIDDEN_NON_DEFAULT_NAME = "The block name is hidden, even though it is not the default block name and the block's type is not clear from its visual appearance";
    private static final String FINDING_UNCLEAR_BLOCK_SHOWN_DEFAULT_NAME = "The block name is shown, even though it is the default block name (and the block's type is not clear from its visual appearance)";
    private static final FindingPropertyList RECOMMENDED_ACTION_HIDE = FindingPropertyList.singleton((String)"Recommended Action", (String)"Hide the block name.");
    private static final FindingPropertyList RECOMMENDED_ACTION_HIDE_OR_RENAME = FindingPropertyList.singleton((String)"Recommended Action", (String)"Hide the block name or modify the block name to be descriptive instead of the default name.");
    private static final FindingPropertyList RECOMMENDED_ACTION_SHOW = FindingPropertyList.singleton((String)"Recommended Action", (String)"Show the block name.");
    @CheckOption(name="Visually clear block types", description="The block types that have a clear type due to their visual appearance. The given block types apply to the 'type' property of Simulink blocks or to the 'SourceType' property (for blocks of type 'Reference'). See [Configuring Simulink Block Types](./documentation/howto/improving-analysis-results-for-simulink/#configuring-block-types-in-simulink-analyses).", multilineText=true)
    private Set<String> clearBlockTypes = Set.of("From", "Goto", "Ground", "Logic", "Merge", "MinMax", "ModelReference", "MultiPortSwitch", "Product", "RelationalOperator", "Saturate", "Switch", "Terminator", "Trigonometry", "UnitDelay", "Sum", "Compare To Constant", "Compare To Zero");

    public void execute() {
        this.context.getSimulinkContext().getSimulinkModelForModelFile().ifPresent(this::checkBlocks);
    }

    private void checkBlocks(SimulinkModel model) {
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            boolean blockHasVisibleName = block.hasVisibleName();
            if (this.isVisuallyClearBlockType(block)) {
                if (!blockHasVisibleName) continue;
                this.buildFinding(FINDING_CLEAR_BLOCK_SHOWN_NAME, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_HIDE).createAndStore();
                continue;
            }
            boolean nameUsedByLibraryExplorer = SimulinkBlockNameUtils.hasNameUsedByLibraryExplorer((SimulinkBlock)block);
            if (blockHasVisibleName && nameUsedByLibraryExplorer) {
                this.buildFinding(FINDING_UNCLEAR_BLOCK_SHOWN_DEFAULT_NAME, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_HIDE_OR_RENAME).createAndStore();
                continue;
            }
            if (blockHasVisibleName || nameUsedByLibraryExplorer) continue;
            this.buildFinding(FINDING_UNCLEAR_BLOCK_HIDDEN_NON_DEFAULT_NAME, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_SHOW).createAndStore();
        }
    }

    private boolean isVisuallyClearBlockType(SimulinkBlock block) {
        String blockTypeOrSourceType = SimulinkUtils.getTypeOrSourceType((SimulinkBlock)block);
        return blockTypeOrSourceType != null && this.clearBlockTypes.contains(blockTypeOrSourceType);
    }
}

