/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkResolvedDataTypes;
import org.conqat.lib.simulink.types.SimulinkDataTypeUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.jmaab.jc_0800", languages={ELanguage.SIMULINK})
public class SimulinkFloatingPointComparisonCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended action", (String)"Compare floating-point values to lower and upper bounds instead");
    private static final String FINDING_MESSAGE = "Equivalence comparison of floating-point data";
    private static final Set<String> EQUIVALENCE_OPERATORS = Set.of("==", "~=");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        SimulinkResolvedDataTypes resolvedDatatypes = this.context.getSimulinkContext().getSimulinkOutputDataTypesForModelFile().orElse(null);
        if (resolvedDatatypes == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, Set.of("RelationalOperator"), (boolean)false, (boolean)false)) {
            Set inputDataTypes;
            String parameter = block.getParameter("Operator");
            if (parameter == null || !EQUIVALENCE_OPERATORS.contains(parameter) || !(inputDataTypes = resolvedDatatypes.getInputDataTypes(block)).stream().anyMatch(SimulinkDataTypeUtils::isFloatingPointDataType)) continue;
            this.buildFinding(FINDING_MESSAGE, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }
}

