/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.SimulinkPortBase;
import org.conqat.lib.simulink.model.datahandler.LabelLayoutData;
import org.conqat.lib.simulink.model.datahandler.simulink.SimulinkPortLabelUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.jspecify.annotations.Nullable;

@Check(id="cqse.hism.hisl_0008", languages={ELanguage.SIMULINK})
public class SimulinkForIteratorBlockUsageCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE_ITERATION_LIMIT = "This For Iterator block has the 'Iteration limit source' set to 'external' and does not use a block with constant value as its source, which could lead to unpredicted loops in the generated code";
    private static final String FINDING_MESSAGE_SET_NEXT_I_EXTERNALLY = "This For Iterator block has the 'Set next i (iteration variable) externally' parameter set, which could lead to unpredicted loops in the generated code";
    private static final String RECOMMENDED_ACTION_ITERATION_LIMIT = "Either set the block parameter 'Iteration limit source' to 'internal' or use a Probe, Width or Constant block as source.";
    private static final String RECOMMENDED_ACTION_SET_NEXT_I_EXTERNALLY = "Deselect the 'Set next i (iteration variable) externally' block parameter.";
    private static final String RECOMMENDED_ACTION_SHOW_ITERATION_VARIABLE = "Also select the 'Show iteration variable' block parameter to be able to observe the iteration value during simulation.";
    private static final Set<String> CONSTANT_VALUE_BLOCK_SOURCE_TYPES = Set.of("Width", "Probe", "Constant");
    private static final Map<String, String> BLOCK_TYPES_NOT_IMPACTING_THE_SOURCE = Map.of("SignalSpecification", "1");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, Collections.singleton("ForIterator"), (boolean)false, (boolean)false)) {
            boolean externalNonConstantIterator = SimulinkForIteratorBlockUsageCheck.checkIterationLimit(block);
            boolean externalCheckNext = SimulinkForIteratorBlockUsageCheck.checkSetNextIExternally(block);
            boolean shownIterationVariable = SimulinkForIteratorBlockUsageCheck.checkShowIterationVariable(block);
            if (externalNonConstantIterator) {
                if (shownIterationVariable) {
                    this.createFinding(block, FINDING_MESSAGE_ITERATION_LIMIT, SimulinkForIteratorBlockUsageCheck.createFindingProperty(List.of(RECOMMENDED_ACTION_ITERATION_LIMIT, RECOMMENDED_ACTION_SHOW_ITERATION_VARIABLE)));
                } else {
                    this.createFinding(block, FINDING_MESSAGE_ITERATION_LIMIT, SimulinkForIteratorBlockUsageCheck.createFindingProperty(List.of(RECOMMENDED_ACTION_ITERATION_LIMIT)));
                }
            }
            if (!externalCheckNext) continue;
            if (shownIterationVariable) {
                this.createFinding(block, FINDING_MESSAGE_SET_NEXT_I_EXTERNALLY, SimulinkForIteratorBlockUsageCheck.createFindingProperty(List.of(RECOMMENDED_ACTION_SET_NEXT_I_EXTERNALLY, RECOMMENDED_ACTION_SHOW_ITERATION_VARIABLE)));
                continue;
            }
            this.createFinding(block, FINDING_MESSAGE_SET_NEXT_I_EXTERNALLY, SimulinkForIteratorBlockUsageCheck.createFindingProperty(List.of(RECOMMENDED_ACTION_SET_NEXT_I_EXTERNALLY)));
        }
    }

    private static FindingPropertyList createFindingProperty(List<String> findingMessages) {
        String findingMessage = findingMessages.stream().collect(Collectors.joining(System.lineSeparator()));
        return FindingPropertyList.singleton((String)"Recommended Action", (String)findingMessage);
    }

    private void createFinding(SimulinkBlock block, String findingMessage, FindingPropertyList findingPropertyList) {
        this.context.buildFinding(findingMessage, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(findingPropertyList).createAndStore();
    }

    private static boolean checkIterationLimit(SimulinkBlock block) {
        return "external".equals(block.getParameter("IterationSource")) && SimulinkForIteratorBlockUsageCheck.isNonConstantSourceBlock(SimulinkForIteratorBlockUsageCheck.getSourceBlockTypeForIterationLimit(block));
    }

    private static boolean checkSetNextIExternally(SimulinkBlock block) {
        return !"off".equals(block.getParameter("ShowIterationPort")) && "on".equals(block.getParameter("ExternalIncrement"));
    }

    private static boolean checkShowIterationVariable(SimulinkBlock block) {
        return "off".equals(block.getParameter("ShowIterationPort"));
    }

    private static String getSourceBlockTypeForIterationLimit(SimulinkBlock forIteratorBlock) {
        SimulinkBlock directAncestor = SimulinkUtils.getConnectedBlock((SimulinkInPort)SimulinkForIteratorBlockUsageCheck.getIterationLimitSourcePort(forIteratorBlock));
        SimulinkBlock sourceBlock = SimulinkForIteratorBlockUsageCheck.getSourceBlockRecursively(directAncestor);
        if (sourceBlock == null) {
            return null;
        }
        return sourceBlock.getType();
    }

    private static SimulinkBlock getSourceBlockRecursively(SimulinkBlock block) {
        if (block == null) {
            return null;
        }
        if (SimulinkUtils.isInport((SimulinkBlock)block) && block.getParent().isOfType("SubSystem")) {
            SimulinkInPort inPort = SimulinkUtils.getInportFromSubsystemInportBlock((SimulinkBlock)block);
            SimulinkBlock ancestor = SimulinkForIteratorBlockUsageCheck.getNextAncestor(inPort);
            SimulinkBlock sourceBlock = SimulinkForIteratorBlockUsageCheck.getSourceBlockRecursively(ancestor);
            if (sourceBlock == null) {
                return block;
            }
            return sourceBlock;
        }
        if (BLOCK_TYPES_NOT_IMPACTING_THE_SOURCE.containsKey(block.getType())) {
            SimulinkInPort inPort = block.getInPort(BLOCK_TYPES_NOT_IMPACTING_THE_SOURCE.get(block.getType()));
            SimulinkBlock ancestor = SimulinkForIteratorBlockUsageCheck.getNextAncestor(inPort);
            return SimulinkForIteratorBlockUsageCheck.getSourceBlockRecursively(ancestor);
        }
        return block;
    }

    private static SimulinkBlock getNextAncestor(SimulinkInPort inPort) {
        SimulinkBlock ancestor = SimulinkUtils.getConnectedBlock((SimulinkInPort)inPort);
        if (ancestor != null && ancestor.isOfType("SubSystem")) {
            SimulinkOutPort outPort = SimulinkUtils.getConnectedOutPort((SimulinkInPort)inPort);
            ancestor = SimulinkUtils.getSubsystemOutportBlockFromOutport((SimulinkOutPort)outPort);
            inPort = ancestor.getInPort("1");
            ancestor = SimulinkUtils.getConnectedBlock((SimulinkInPort)inPort);
        }
        return ancestor;
    }

    private static boolean isNonConstantSourceBlock(@Nullable String blockType) {
        return !CONSTANT_VALUE_BLOCK_SOURCE_TYPES.contains(blockType);
    }

    private static @Nullable SimulinkInPort getIterationLimitSourcePort(SimulinkBlock forIteratorBlock) {
        for (SimulinkInPort inPort : forIteratorBlock.getInPorts()) {
            LabelLayoutData portData = SimulinkPortLabelUtils.obtainForIteratorPortData((SimulinkPortBase)inPort);
            if (!portData.getText().equals("N")) continue;
            return inPort;
        }
        return null;
    }
}

