/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.design.RootInportSpec", languages={ELanguage.SIMULINK})
public class SimulinkRootModelInportBlockSpecificationsCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "Undefined attribute(s) ({0}) in root-level inport block";
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Set a value for this parameter(s).");
    private static final List<Pair<String, String>> INHERITED_PARAMETERS = List.of(Pair.createPair((Object)"PortDimensions", (Object)"-1"), Pair.createPair((Object)"OutDataTypeStr", (Object)"Inherit: auto"), Pair.createPair((Object)"SampleTime", (Object)"-1"));

    public void execute() {
        this.context.getSimulinkContext().getSimulinkModelForModelFile().ifPresent(model -> {
            if (model.isLibraryModel()) {
                return;
            }
            model.getSubBlocks().stream().filter(subBlock -> subBlock.isOfType("Inport") && !SimulinkRootModelInportBlockSpecificationsCheck.isInBusBlock(subBlock)).forEach(this::checkAttributes);
        });
    }

    private static boolean isInBusBlock(SimulinkBlock subBlock) {
        return subBlock.getParameter("InterfaceData.PortName") != null;
    }

    private void checkAttributes(SimulinkBlock inport) {
        if (SimulinkUtils.isCommentedBlock((SimulinkBlock)inport)) {
            return;
        }
        String undefinedParameters = INHERITED_PARAMETERS.stream().filter(value -> SimulinkRootModelInportBlockSpecificationsCheck.isNotSet((Pair<String, String>)value, inport)).map(ImmutablePair::getFirst).collect(Collectors.joining(", "));
        if (!undefinedParameters.isEmpty()) {
            this.buildFinding(MessageFormat.format(FINDING_MESSAGE, undefinedParameters), (ElementLocation)this.buildLocation().forSimulinkBlock(inport)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }

    private static boolean isNotSet(Pair<String, String> parameter, SimulinkBlock inport) {
        String definedValue = inport.getDeclaredParameter((String)parameter.getFirst());
        return definedValue == null || ((String)parameter.getSecond()).equals(definedValue);
    }
}

