/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayDeque;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.datahandler.GotoFromResolver;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.hism.hisl_0010b", languages={ELanguage.SIMULINK})
public class SimulinkUsageOfIfActionSubsystemBlocksCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "If block is not connected to an If Action Subsystem block";
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Connect the If block to an If Action Subsystem block");

    public void execute() {
        this.context.getSimulinkContext().getSimulinkModelForModelFile().ifPresent(this::checkModel);
    }

    private void checkModel(SimulinkModel model) {
        GotoFromResolver resolver = model.getGotoFromResolver();
        for (SimulinkBlock block : SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, Set.of("If"), (boolean)false, (boolean)false)) {
            String elseIfExpression = block.getParameter("ElseIfExpressions");
            if (StringUtils.isEmpty((String)elseIfExpression) || SimulinkUsageOfIfActionSubsystemBlocksCheck.allOutputsConnectedToIfAction(block, resolver)) continue;
            this.buildFinding(FINDING_MESSAGE, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }

    private static boolean allOutputsConnectedToIfAction(SimulinkBlock block, GotoFromResolver resolver) {
        ArrayDeque outPorts = new ArrayDeque(block.getOutPorts());
        while (!outPorts.isEmpty()) {
            SimulinkOutPort outPort = (SimulinkOutPort)outPorts.pop();
            if (!outPort.isConnected()) {
                return false;
            }
            SimulinkLine line = outPort.getAnyLine();
            SimulinkInPort dstPort = line.getDstPort();
            if (dstPort == null) {
                return false;
            }
            SimulinkBlock dstBlock = dstPort.getBlock();
            if (dstBlock.isOfType("Goto")) {
                resolver.getConnectedFromBlocks(dstBlock).forEach(fromBlock -> outPorts.addAll(fromBlock.getOutPorts()));
                continue;
            }
            if ("ifaction".equals(dstPort.getIndex())) continue;
            return false;
        }
        return true;
    }
}

