/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkResolvedDataTypes;
import org.conqat.lib.simulink.types.SimulinkDataTypeUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.hism.hisl_0034", languages={ELanguage.SIMULINK})
public class SimulinkUsageOfSignalRoutingBlocksCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "Switch block uses the inequality (~=) operator on a floating-point data type";
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Change the input signal to not be single, double, or any custom storage class. Alternatively eliminate the ~= operator within the Switch block.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        SimulinkResolvedDataTypes resolvedTypes = this.context.getSimulinkContext().getSimulinkOutputDataTypesForModelFile().orElse(null);
        if (model == null || resolvedTypes == null) {
            return;
        }
        SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, Set.of("Switch"), (boolean)false, (boolean)false).stream().filter(block -> SimulinkUsageOfSignalRoutingBlocksCheck.isSecondInportFloatingPoint(block, resolvedTypes) && SimulinkUsageOfSignalRoutingBlocksCheck.usesInequalityOperator(block)).forEach(block -> this.buildFinding(FINDING_MESSAGE, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore());
    }

    private static boolean isSecondInportFloatingPoint(SimulinkBlock switchBlock, SimulinkResolvedDataTypes resolvedTypes) {
        String inputDataType = resolvedTypes.getInputDataType(switchBlock, "2");
        return inputDataType != null && SimulinkDataTypeUtils.isFloatingPointDataType((String)inputDataType);
    }

    private static boolean usesInequalityOperator(SimulinkBlock switchBlock) {
        String criteria = switchBlock.getParameter("Criteria");
        return criteria != null && criteria.contains("~=");
    }
}

