/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.simulink.simulink.phases.SimulinkCheckFileReferencesResolver;
import eu.cqse.check.simulink.simulink.phases.SimulinkDataDictionaryLoadingPhase;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.builder.ISimulinkDataDictionaryEntry;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.SimulinkResolvedDataTypes;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.maab.jc_0141", languages={ELanguage.SIMULINK})
public class SimulinkUseOfSwitchBlockCheck
extends CheckImplementationBase {
    private static final String EXPECTED_CRITERIA_SETTING = "u2 ~= 0";
    private static final FindingPropertyList CRITERIA_RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Use u2~=0 as block parameter.");
    private static final String CRITERIA_FINDING_MESSAGE = "Switch block parameter `Criteria for passing first input` shall be set to `u2~=0` but is %s";
    private static final String BOOLEAN_FINDING_MESSAGE = "Input type for the second port of the switch block shall be `boolean` but is %s";
    private static final FindingPropertyList BOOLEAN_RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Set Boolean as data type of the control input.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        SimulinkResolvedDataTypes types = this.context.getSimulinkContext().getSimulinkOutputDataTypesForModelFile().orElse(null);
        if (types == null) {
            return;
        }
        List<SimulinkDataDictionary> dictionaries = new SimulinkCheckFileReferencesResolver(this.context).getSimulinkDataDictionariesForModel(model, this.context.accessPhaseResult(SimulinkDataDictionaryLoadingPhase.class));
        for (SimulinkBlock block : SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, Collections.singleton("Switch"), (boolean)false, (boolean)false)) {
            Optional<SimulinkBlock> switchCriteriaBlock;
            String criteria = block.getParameter("Criteria");
            if (!EXPECTED_CRITERIA_SETTING.equals(criteria)) {
                this.buildFinding(String.format(CRITERIA_FINDING_MESSAGE, MarkupUtils.formatAsSourceCode((String)criteria)), (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(CRITERIA_RECOMMENDED_ACTION).createAndStore();
            }
            if ((switchCriteriaBlock = SimulinkUseOfSwitchBlockCheck.getPredecessorBlockAtFirstPort(block)).isEmpty()) {
                LogManager.getLogger().warn("Block " + block.getId() + " in " + this.context.getUniformPath() + " could not be checked. Seems to be a malformed switch block.");
                continue;
            }
            this.checkSecondPortInputType(types, block, switchCriteriaBlock.get(), dictionaries);
        }
    }

    private void checkSecondPortInputType(SimulinkResolvedDataTypes types, SimulinkBlock block, SimulinkBlock switchCriteriaBlock, List<SimulinkDataDictionary> dataDictionaries) {
        String controlInputType = types.getInputDataType(block, "2");
        if (controlInputType == null) {
            String blockLocation = this.context.buildLocation().forSimulinkBlock(switchCriteriaBlock).getQualifiedName();
            LogManager.getLogger().warn("Input type of block " + blockLocation + " could not be resolved. Ignoring this block.");
            return;
        }
        if ("NOT_CONNECTED".equals(controlInputType)) {
            return;
        }
        if ("Unknown".equals(controlInputType)) {
            return;
        }
        if (!"boolean".equals(controlInputType) && !SimulinkUseOfSwitchBlockCheck.secondPortFeedsFromBooleanDictionaryParameter(dataDictionaries, switchCriteriaBlock.getParameter("Value"))) {
            this.buildFinding(String.format(BOOLEAN_FINDING_MESSAGE, MarkupUtils.formatAsSourceCode((String)controlInputType)), (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(BOOLEAN_RECOMMENDED_ACTION).createAndStore();
        }
    }

    private static boolean secondPortFeedsFromBooleanDictionaryParameter(List<SimulinkDataDictionary> dataDictionaries, String switchCriteriaDictionaryEntryName) {
        for (SimulinkDataDictionary dictionary : dataDictionaries) {
            for (ISimulinkDataDictionaryEntry entry : dictionary.getEntries()) {
                if (!entry.getName().equals(switchCriteriaDictionaryEntryName) || !"boolean".equals(entry.getDataType())) continue;
                return true;
            }
        }
        return false;
    }

    private static Optional<SimulinkBlock> getPredecessorBlockAtFirstPort(SimulinkBlock block) {
        List inLines = block.getInLines();
        if (inLines.size() <= 1) {
            return Optional.empty();
        }
        SimulinkOutPort sourcePort = ((SimulinkLine)inLines.get(1)).getSrcPort();
        if (sourcePort == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(sourcePort.getBlock());
    }
}

