/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.hism.hisl_0023", languages={ELanguage.SIMULINK})
public class SimulinkVariantVerificationCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "The variant activation time is set to " + MarkupUtils.formatAsSourceCode((String)"code compile");
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)("Set the variant activation time to +" + MarkupUtils.formatAsSourceCode((String)"update diagram") + " or " + MarkupUtils.formatAsSourceCode((String)"update diagram analyze all choices")));

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock subsystem : SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, Set.of("SubSystem"), (boolean)false, (boolean)false)) {
            if (!SimulinkUtils.isVariantSubsystem((SimulinkBlock)subsystem)) continue;
            this.checkSettingsOfVariantSubsystems(subsystem);
        }
    }

    private void checkSettingsOfVariantSubsystems(SimulinkBlock subsystem) {
        String variantActivationTime = subsystem.getParameter("VariantActivationTime");
        if ("code compile".equals(variantActivationTime)) {
            this.buildFinding(FINDING_MESSAGE, (ElementLocation)this.buildLocation().forSimulinkBlock(subsystem)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }
}

