/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.simulink.stateflow.EStateflowStateActionType;
import eu.cqse.check.util.simulink.StateflowCheckUtils;
import eu.cqse.check.util.simulink.StateflowStateAction;
import java.util.Optional;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.jmaab.jc_0740", languages={ELanguage.SIMULINK})
public class SimulinkStateflowUseExitInStateActionCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Remove the 'exit' action type and introduce state transitions for the intended logic.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null || model.getStateflowMachine() == null) {
            return;
        }
        for (StateflowChart chart : model.getStateflowMachine().getCharts(false)) {
            for (StateflowState state : StateflowUtils.listStatesDepthFirst((StateflowChart)chart, (boolean)false)) {
                this.checkActionsOfState(state);
            }
        }
    }

    private void checkActionsOfState(StateflowState state) {
        for (StateflowStateAction stateAction : StateflowCheckUtils.splitStateActionsFromStateLabel((StateflowState)state)) {
            Optional<IToken> exitToken = stateAction.actionDeclaration.stream().filter(token -> EStateflowStateActionType.fromString(token.getText()).isPresent() && EStateflowStateActionType.fromString(token.getText()).get() == EStateflowStateActionType.EXIT).findFirst();
            if (exitToken.isEmpty()) continue;
            String stateName = StateflowUtils.getStateName((StateflowState)state);
            this.buildFinding("Stateflow state " + MarkupUtils.formatAsSourceCode((String)stateName) + " contains action type " + MarkupUtils.formatAsSourceCode((String)exitToken.get().getText()) + " in line " + (exitToken.get().getLineNumber() + 1), (ElementLocation)this.buildLocation().forStateflowNode((StateflowNodeBase)state)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
            return;
        }
    }
}

