/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.simulink.simulink.phases.SimulinkDataDictionaryLoadingPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkFileReferencesPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkModelBlockIdListingPhase;
import eu.cqse.check.simulink.simulink.utils.ExternalConfigSetUtils;
import java.text.MessageFormat;
import org.conqat.lib.simulink.builder.SimulinkConfigSet;
import org.conqat.lib.simulink.model.SimulinkModel;

@Check(id="cqse.jmaab.jc_0772", languages={ELanguage.SIMULINK}, phases={SimulinkDataDictionaryLoadingPhase.class, SimulinkFileReferencesPhase.class, SimulinkModelBlockIdListingPhase.class})
public class SimulinkTransitionOrderCheck
extends CheckImplementationBase {
    private static final String INFEASIBLE_PATH_FINDING_MESSAGE = "The diagnostic option `Unreachable execution path` is set to `{0}`";
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Set the diagnostic option 'Unreachable execution path' to 'error'.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null || model.isLibraryModel() || model.isSubsystem()) {
            return;
        }
        SimulinkConfigSet externalConfigSet = ExternalConfigSetUtils.getExternalConfigSet(model, this.context).orElse(null);
        String parameterValue = ExternalConfigSetUtils.getParameter(model, externalConfigSet, "SFUnreachableExecutionPathDiag").orElse(null);
        if (!"error".equalsIgnoreCase(parameterValue)) {
            this.buildFinding(MessageFormat.format(INFEASIBLE_PATH_FINDING_MESSAGE, parameterValue), this.buildLocation().forElement()).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }
}

