/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.matlab.EMatlabActionEntityType;
import eu.cqse.check.matlab.MatlabActionAstNode;
import eu.cqse.check.matlab.MatlabActionAstUtils;
import eu.cqse.check.matlab.MatlabActionParserException;
import eu.cqse.check.matlab.MatlabActionTypeResolver;
import eu.cqse.check.simulink.simulink.phases.SimulinkCheckFileReferencesResolver;
import eu.cqse.check.simulink.simulink.phases.SimulinkDataDictionaryLoadingPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkFileReferencesPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkModelBlockIdListingPhase;
import eu.cqse.check.simulink.stateflow_data_typing.StateflowVariableTypeExtractor;
import eu.cqse.check.util.simulink.StateflowCheckUtils;
import eu.cqse.check.util.simulink.StateflowStateAction;
import eu.cqse.check.util.simulink.StateflowTransitionParts;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkResolvedDataTypes;
import org.conqat.lib.simulink.model.stateflow.IStateflowElement;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowDeclContainerBase;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.hism.hisf_0211", languages={ELanguage.SIMULINK}, phases={SimulinkDataDictionaryLoadingPhase.class, SimulinkFileReferencesPhase.class, SimulinkModelBlockIdListingPhase.class})
public class SimulinkUnaryOperatorInStateflowChartCheck
extends CheckImplementationBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String FINDING_MESSAGE = "Use of unary minus operator on unsigned data type: {0}";
    private static final Pattern FIXED_DATA_REGEX = Pattern.compile("fixdt\\(([^,]+)(,.+)*\\)");
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Explicitly modify the unary operator on unsigned data types.");
    private static final Set<String> UNSIGNED_NUMBER_FORMATS = Set.of("uint8", "uint16", "uint32", "uint64");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        SimulinkResolvedDataTypes signalTypeResolution = this.context.getSimulinkContext().getSimulinkOutputDataTypesForModelFile().orElse(null);
        List<SimulinkDataDictionary> dataDictionaries = new SimulinkCheckFileReferencesResolver(this.context).getSimulinkDataDictionariesForModel(model, this.context.accessPhaseResult(SimulinkDataDictionaryLoadingPhase.class));
        if (model == null || signalTypeResolution == null || model.getStateflowMachine() == null) {
            return;
        }
        for (StateflowChart chart : model.getStateflowMachine().getCharts(false)) {
            if (StateflowUtils.hasActionLanguageC((StateflowChart)chart)) {
                for (StateflowTransition transition : StateflowUtils.getAllTransitionsAsSet((StateflowChart)chart, (boolean)false)) {
                    this.checkStateflowCppTransition(transition, signalTypeResolution);
                }
                for (StateflowState state : StateflowUtils.listStatesDepthFirst((StateflowChart)chart, (boolean)false)) {
                    this.checkStateflowCppState(state, signalTypeResolution);
                }
                continue;
            }
            for (StateflowTransition transition : StateflowUtils.getAllTransitionsAsSet((StateflowChart)chart, (boolean)false)) {
                this.checkStateflowMatlabTransition(transition, signalTypeResolution, dataDictionaries);
            }
            for (StateflowState state : StateflowUtils.listStatesDepthFirst((StateflowChart)chart, (boolean)false)) {
                this.checkStateflowMatlabState(state, signalTypeResolution, dataDictionaries);
            }
        }
    }

    private void checkStateflowCppTransition(StateflowTransition transition, SimulinkResolvedDataTypes signalTypeResolution) {
        CCSMAssert.isTrue((boolean)StateflowUtils.hasActionLanguageC((StateflowChart)transition.accessChart()), (String)"function for action-language C called with MATLAB code");
        StateflowTransitionParts stateflowTransitionParts = StateflowCheckUtils.splitTransitionLabel((StateflowTransition)transition);
        StateflowVariableTypeExtractor variableTypeExtractor = new StateflowVariableTypeExtractor(signalTypeResolution);
        ArrayList<List<IToken>> targetOperations = new ArrayList<List<IToken>>();
        targetOperations.addAll(SimulinkUnaryOperatorInStateflowChartCheck.findViolationsOnTokensInCppTransition(stateflowTransitionParts.condition, transition, variableTypeExtractor));
        targetOperations.addAll(SimulinkUnaryOperatorInStateflowChartCheck.findViolationsOnTokensInCppTransition(stateflowTransitionParts.conditionAction, transition, variableTypeExtractor));
        targetOperations.addAll(SimulinkUnaryOperatorInStateflowChartCheck.findViolationsOnTokensInCppTransition(stateflowTransitionParts.transitionAction, transition, variableTypeExtractor));
        for (List list : targetOperations) {
            String operationText = TokenStreamTextUtils.concatTokenTexts((List)list);
            this.buildFinding(MessageFormat.format(FINDING_MESSAGE, MarkupUtils.formatAsSourceCode((String)operationText)), (ElementLocation)this.buildLocation().forStateflowTransition(transition)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }

    private void checkStateflowMatlabTransition(StateflowTransition transition, SimulinkResolvedDataTypes signalTypeResolution, List<SimulinkDataDictionary> dataDictionaries) {
        CCSMAssert.isFalse((boolean)StateflowUtils.hasActionLanguageC((StateflowChart)transition.accessChart()), (String)"function for action-language MATLAB called with C code");
        StateflowTransitionParts stateflowTransitionParts = StateflowCheckUtils.splitTransitionLabel((StateflowTransition)transition);
        ArrayList<List<IToken>> targetOperations = new ArrayList<List<IToken>>();
        targetOperations.addAll(this.findViolationsOnTokensInMatlabTransition(stateflowTransitionParts.condition, transition, signalTypeResolution, dataDictionaries));
        targetOperations.addAll(this.findViolationsOnTokensInMatlabTransition(stateflowTransitionParts.conditionAction, transition, signalTypeResolution, dataDictionaries));
        targetOperations.addAll(this.findViolationsOnTokensInMatlabTransition(stateflowTransitionParts.transitionAction, transition, signalTypeResolution, dataDictionaries));
        for (List list : targetOperations) {
            String operationText = TokenStreamTextUtils.concatTokenTexts((List)list);
            this.buildFinding(MessageFormat.format(FINDING_MESSAGE, MarkupUtils.formatAsSourceCode((String)operationText)), (ElementLocation)this.buildLocation().forStateflowTransition(transition)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }

    private List<List<IToken>> findViolationsOnTokensInMatlabTransition(List<IToken> tokens, StateflowTransition transition, SimulinkResolvedDataTypes signalTypeResolution, List<SimulinkDataDictionary> dataDictionaries) {
        try {
            MatlabActionTypeResolver ast = MatlabActionTypeResolver.from(tokens, (StateflowTransition)transition, (SimulinkResolvedDataTypes)signalTypeResolution, dataDictionaries);
            return SimulinkUnaryOperatorInStateflowChartCheck.findViolationsInMatlabAst(ast);
        }
        catch (MatlabActionParserException e) {
            LOGGER.debug("Parse error on transition " + this.context.buildLocation().forStateflowTransition(transition).getQualifiedName(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static List<List<IToken>> findViolationsInMatlabAst(MatlabActionTypeResolver ast) {
        List unaryOps = MatlabActionAstUtils.listNodesOfEntityTypeRecursively((MatlabActionAstNode)ast.getRootNode(), (EMatlabActionEntityType[])new EMatlabActionEntityType[]{EMatlabActionEntityType.UNARY_OPERATION});
        ArrayList<MatlabActionAstNode> violatingUnaryOperators = new ArrayList<MatlabActionAstNode>();
        for (MatlabActionAstNode unaryOp : unaryOps) {
            String childDataType = ast.inferDataTypeOf((MatlabActionAstNode)unaryOp.getChildren().get(0));
            if (!TokenStreamUtils.startsWith((List)unaryOp.getTokens(), (ETokenType[])new ETokenType[]{ETokenType.MINUS}) || !SimulinkUnaryOperatorInStateflowChartCheck.isUnsignedDataType(childDataType)) continue;
            violatingUnaryOperators.add(unaryOp);
        }
        return violatingUnaryOperators.stream().map(MatlabActionAstNode::getTokens).collect(Collectors.toList());
    }

    private void checkStateflowMatlabState(StateflowState state, SimulinkResolvedDataTypes resolvedSignalTypes, List<SimulinkDataDictionary> dataDictionaries) {
        CCSMAssert.isFalse((boolean)StateflowUtils.hasActionLanguageC((StateflowChart)StateflowUtils.getChart((IStateflowElement)state)), (String)"function for action-language MATLAB called with C code");
        ArrayList<List<IToken>> targetOperations = new ArrayList<List<IToken>>();
        for (StateflowStateAction stateflowStateAction : StateflowCheckUtils.splitStateActionsFromStateLabel((StateflowState)state)) {
            try {
                MatlabActionTypeResolver ast = MatlabActionTypeResolver.from((List)stateflowStateAction.actionCode, (StateflowState)state, (SimulinkResolvedDataTypes)resolvedSignalTypes, dataDictionaries);
                targetOperations.addAll(SimulinkUnaryOperatorInStateflowChartCheck.findViolationsInMatlabAst(ast));
            }
            catch (MatlabActionParserException e) {
                LOGGER.debug("Parse error on state " + this.context.buildLocation().forStateflowNode((StateflowNodeBase)state).getQualifiedName(), (Throwable)e);
            }
        }
        for (List list : targetOperations) {
            String operationText = TokenStreamTextUtils.concatTokenTexts((List)list);
            this.buildFinding(MessageFormat.format(FINDING_MESSAGE, MarkupUtils.formatAsSourceCode((String)operationText)), (ElementLocation)this.buildLocation().forStateflowNode((StateflowNodeBase)state)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }

    private void checkStateflowCppState(StateflowState state, SimulinkResolvedDataTypes resolvedSignalTypes) {
        CCSMAssert.isTrue((boolean)StateflowUtils.hasActionLanguageC((StateflowChart)StateflowUtils.getChart((IStateflowElement)state)), (String)"function for action-language C called with Matlab code");
        ArrayList<List<IToken>> targetOperations = new ArrayList<List<IToken>>();
        for (StateflowStateAction stateflowStateAction : StateflowCheckUtils.splitStateActionsFromStateLabel((StateflowState)state)) {
            targetOperations.addAll(SimulinkUnaryOperatorInStateflowChartCheck.findViolationsOnTokensInCppState(stateflowStateAction.actionCode, state, new StateflowVariableTypeExtractor(resolvedSignalTypes)));
        }
        for (List list : targetOperations) {
            String operationText = TokenStreamTextUtils.concatTokenTexts((List)list);
            this.buildFinding(MessageFormat.format(FINDING_MESSAGE, MarkupUtils.formatAsSourceCode((String)operationText)), (ElementLocation)this.buildLocation().forStateflowNode((StateflowNodeBase)state)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }

    private static List<List<IToken>> findViolationsOnTokensInCppTransition(List<IToken> tokens, StateflowTransition transition, StateflowVariableTypeExtractor variableTypeExtractor) {
        ArrayList<List<IToken>> unaryMinusExpressions = new ArrayList<List<IToken>>();
        for (Integer minusIndex : SimulinkUnaryOperatorInStateflowChartCheck.getIndicesOfUnaryMinusReferences(tokens)) {
            String dataType = variableTypeExtractor.determineType(tokens.get(minusIndex + 1).getText(), transition);
            if (dataType == null || dataType.equals("Unknown") || dataType.equals("NOT_CONNECTED") || !SimulinkUnaryOperatorInStateflowChartCheck.isUnsignedDataType(dataType)) continue;
            unaryMinusExpressions.add(tokens.subList(minusIndex, minusIndex + 2));
        }
        return unaryMinusExpressions;
    }

    private static List<List<IToken>> findViolationsOnTokensInCppState(List<IToken> tokens, StateflowState state, StateflowVariableTypeExtractor variableTypeExtractor) {
        ArrayList<List<IToken>> targetOperations = new ArrayList<List<IToken>>();
        for (Integer minusIndex : SimulinkUnaryOperatorInStateflowChartCheck.getIndicesOfUnaryMinusReferences(tokens)) {
            String dataType = variableTypeExtractor.determineType(tokens.get(minusIndex + 1).getText(), (StateflowDeclContainerBase)state);
            if (dataType == null || dataType.equals("Unknown") || dataType.equals("NOT_CONNECTED") || !SimulinkUnaryOperatorInStateflowChartCheck.isUnsignedDataType(dataType)) continue;
            targetOperations.add(tokens.subList(minusIndex, minusIndex + 2));
        }
        return targetOperations;
    }

    private static boolean isUnsignedDataType(String dataType) {
        if (UNSIGNED_NUMBER_FORMATS.contains(dataType)) {
            return true;
        }
        Matcher fixedDataMatcher = FIXED_DATA_REGEX.matcher(dataType);
        if (!fixedDataMatcher.matches()) {
            return false;
        }
        String firstArgument = fixedDataMatcher.group(1);
        if (firstArgument.equals("0")) {
            return true;
        }
        firstArgument = firstArgument.replace("'", "");
        return UNSIGNED_NUMBER_FORMATS.contains(firstArgument);
    }

    private static Set<Integer> getIndicesOfUnaryMinusReferences(List<IToken> tokens) {
        HashSet<Integer> unaryMinusOperationVariables = new HashSet<Integer>();
        Iterator iterator = TokenStreamUtils.allStartingIndicesOfTypeSequence(tokens, (int)0, (int)tokens.size(), (ETokenType[])new ETokenType[]{ETokenType.MINUS, ETokenType.IDENTIFIER}).iterator();
        while (iterator.hasNext()) {
            int minusIndex = (Integer)iterator.next();
            if (minusIndex != 0 && SimulinkUnaryOperatorInStateflowChartCheck.mayPrecedeMinusInSubtraction(tokens.get(minusIndex - 1))) continue;
            unaryMinusOperationVariables.add(minusIndex);
        }
        return unaryMinusOperationVariables;
    }

    private static boolean mayPrecedeMinusInSubtraction(IToken token) {
        ETokenType type = token.getType();
        return type == ETokenType.RBRACK || type == ETokenType.RPAREN || EnumSet.of(ETokenType.ETokenClass.IDENTIFIER, ETokenType.ETokenClass.LITERAL).contains(type.getTokenClass());
    }
}

