/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.sql_like;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-avoid-null-comparison", languages={ELanguage.PLSQL, ELanguage.TSQL, ELanguage.ESQL}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AvoidComparisonWithNullCheck
extends CheckImplementationBase {
    private static final int MATCH_NULL_GROUP = 0;
    private static final int MATCH_COMPARATOR_GROUP = 1;
    private static final Set<ETokenType> NULL_VALUES = Set.of(ETokenType.NULL_LITERAL, ETokenType.NULL);
    private static final Set<ETokenType> COMPARATORS = Set.of(ETokenType.EQUAL, ETokenType.NEQ, ETokenType.EQ);
    private static final Set<String> TSQL_SUBTYPE_WITH_NULL_ASSIGNMENT = Set.of("set", "declare", "exec");
    private static final Set<String> ESQL_SUBTYPE_WITH_NULL_ASSIGNMENT = Set.of("set", "exec");
    private static final TokenPattern NULL_COMPARISON_PATTERN = new TokenPattern().alternative(new Object[]{new TokenPattern().sequence(new Object[]{COMPARATORS}).group(1).sequence(new Object[]{NULL_VALUES}).group(0), new TokenPattern().sequence(new Object[]{NULL_VALUES}).group(0).sequence(new Object[]{COMPARATORS}).group(1)});
    private static final ITokenMatcher OPENING_TOKENS_SELECT_OPTIONS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.INTO, ETokenType.FROM, ETokenType.WHERE, ETokenType.GROUPBY, ETokenType.HAVING});

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        UnmodifiableList tokens = entity.ownStartTokens();
        List matches = NULL_COMPARISON_PATTERN.findAll((List)tokens);
        for (TokenPatternMatch match : matches) {
            if (this.isAssignment((Integer)match.groupIndices(1).get(0), entity, (List<IToken>)tokens)) continue;
            this.buildFinding("Avoid comparison with `" + ((IToken)match.groupTokens(0).get(0)).getText() + "`.", this.buildLocation().forToken((IToken)match.groupTokens(1).get(0))).createAndStore();
        }
    }

    private boolean isAssignment(int comparatorIndex, ShallowEntity entity, List<IToken> tokens) {
        return switch (this.context.getLanguage()) {
            case ELanguage.TSQL -> this.isAssignmentInTSQL(comparatorIndex, entity, tokens);
            case ELanguage.ESQL -> this.isAssignmentInESQL(comparatorIndex, entity, tokens);
            case ELanguage.PLSQL -> this.isAssignmentInPLSQL(comparatorIndex, entity, tokens);
            default -> throw new IllegalStateException("not all languages handled");
        };
    }

    private boolean isAssignmentInPLSQL(int comparatorIndex, ShallowEntity entity, List<IToken> tokens) {
        return this.isAssignmentInSetOfUpdate(comparatorIndex, entity, tokens);
    }

    private boolean isAssignmentInTSQL(int comparatorIndex, ShallowEntity entity, List<IToken> tokens) {
        return TSQL_SUBTYPE_WITH_NULL_ASSIGNMENT.contains(entity.getSubtype()) || this.isAssignmentInSelect(comparatorIndex, entity, tokens) || this.isAssignmentInSetOfUpdate(comparatorIndex, entity, tokens);
    }

    private boolean isAssignmentInESQL(int comparatorIndex, ShallowEntity entity, List<IToken> tokens) {
        return ESQL_SUBTYPE_WITH_NULL_ASSIGNMENT.contains(entity.getSubtype()) || this.isAssignmentInSetOfUpdate(comparatorIndex, entity, tokens);
    }

    private boolean isAssignmentInSelect(int comparatorIndex, ShallowEntity entity, List<IToken> tokens) {
        int indexOfNextOptions = TokenStreamUtils.firstTokenMatching(tokens, (ITokenMatcher)OPENING_TOKENS_SELECT_OPTIONS);
        return entity.getSubtype().equals("select") && (indexOfNextOptions == -1 || comparatorIndex < indexOfNextOptions);
    }

    private boolean isAssignmentInSetOfUpdate(int comparatorIndex, ShallowEntity entity, List<IToken> tokens) {
        int wherePosition = TokenStreamUtils.firstTokenMatching(tokens, (ITokenMatcher)ETokenType.WHERE);
        boolean isUpdate = entity.getSubtype().equals("update") || entity.getSubtype().equals("SQL") && TokenStreamUtils.firstTokenMatching(tokens, (ITokenMatcher)ETokenType.UPDATE) < comparatorIndex;
        return isUpdate && TokenStreamUtils.firstTokenMatching(tokens, (ITokenMatcher)ETokenType.SET) < comparatorIndex && (wherePosition == -1 || comparatorIndex < wherePosition);
    }
}

